/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.helpers;

import com.commercetools.api.models.common.BaseAddress;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.customers.helpers.CustomerSyncStatistics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CustomerBatchValidator
extends BaseBatchValidator<CustomerDraft, CustomerSyncOptions, CustomerSyncStatistics> {
    public static final String CUSTOMER_DRAFT_IS_NULL = "CustomerDraft is null.";
    public static final String CUSTOMER_DRAFT_KEY_NOT_SET = "CustomerDraft with email: %s doesn't have a key. Please make sure all customer drafts have keys.";
    public static final String CUSTOMER_DRAFT_EMAIL_NOT_SET = "CustomerDraft with key: %s doesn't have an email. Please make sure all customer drafts have emails.";
    static final String CUSTOMER_DRAFT_PASSWORD_NOT_SET = "CustomerDraft with key: %s doesn't have a password. Please make sure all customer drafts have passwords.";
    static final String ADDRESSES_ARE_NULL = "CustomerDraft with key: '%s' has null addresses on indexes: '%s'. Please make sure each address is set in the addresses list.";
    static final String ADDRESSES_THAT_KEYS_NOT_SET = "CustomerDraft with key: '%s' has blank address keys on indexes: '%s'. Please make sure each address has a key in the addresses list";
    static final String ADDRESSES_THAT_KEYS_NOT_UNIQUE = "CustomerDraft with key: '%s' has duplicate address keys on indexes: '%s'. Please make sure each address key is unique in the addresses list.";
    static final String BILLING_ADDRESSES_ARE_NOT_VALID = "CustomerDraft with key: '%s' does not contain indices: '%s' of the 'billingAddresses' in the addresses list. Please make sure all customer drafts have valid index values for the 'billingAddresses'.";
    static final String SHIPPING_ADDRESSES_ARE_NOT_VALID = "CustomerDraft with key: '%s' does not contain indices: '%s' of the 'shippingAddresses' in the addresses list. Please make sure all customer drafts have valid index values for the 'shippingAddresses'.";

    public CustomerBatchValidator(@Nonnull CustomerSyncOptions syncOptions, @Nonnull CustomerSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<CustomerDraft>, ReferencedKeys> validateAndCollectReferencedKeys(@Nonnull List<CustomerDraft> customerDrafts) {
        ReferencedKeys referencedKeys = new ReferencedKeys();
        Set validDrafts = customerDrafts.stream().filter(this::isValidCustomerDraft).peek(customerDraft -> this.collectReferencedKeys(referencedKeys, (CustomerDraft)customerDraft)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, (Object)referencedKeys);
    }

    private boolean isValidCustomerDraft(@Nullable CustomerDraft customerDraft) {
        if (customerDraft == null) {
            this.handleError(CUSTOMER_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)customerDraft.getKey())) {
            this.handleError(String.format(CUSTOMER_DRAFT_KEY_NOT_SET, customerDraft.getEmail()));
        } else if (StringUtils.isBlank((CharSequence)customerDraft.getEmail())) {
            this.handleError(String.format(CUSTOMER_DRAFT_EMAIL_NOT_SET, customerDraft.getKey()));
        } else if (StringUtils.isBlank((CharSequence)customerDraft.getPassword())) {
            this.handleError(String.format(CUSTOMER_DRAFT_PASSWORD_NOT_SET, customerDraft.getKey()));
        } else if (this.hasValidAddresses(customerDraft)) {
            return this.hasValidBillingAndShippingAddresses(customerDraft);
        }
        return false;
    }

    private boolean hasValidAddresses(@Nonnull CustomerDraft customerDraft) {
        List addressList = customerDraft.getAddresses();
        if (addressList == null || addressList.isEmpty()) {
            return true;
        }
        if (addressList.stream().noneMatch(Objects::nonNull)) {
            return true;
        }
        List<Integer> indexesOfNullAddresses = this.getIndexes(addressList, Objects::isNull);
        if (!indexesOfNullAddresses.isEmpty()) {
            this.handleError(String.format(ADDRESSES_ARE_NULL, customerDraft.getKey(), indexesOfNullAddresses));
            return false;
        }
        List<Integer> indexesOfBlankAddressKeys = this.getIndexes(addressList, address -> StringUtils.isBlank((CharSequence)address.getKey()));
        if (!indexesOfBlankAddressKeys.isEmpty()) {
            this.handleError(String.format(ADDRESSES_THAT_KEYS_NOT_SET, customerDraft.getKey(), indexesOfBlankAddressKeys));
            return false;
        }
        Predicate<BaseAddress> searchDuplicateKeys = address -> addressList.stream().filter(a -> Objects.equals(a.getKey(), address.getKey())).count() > 1L;
        List<Integer> indexesOfDuplicateAddressKeys = this.getIndexes(addressList, searchDuplicateKeys);
        if (!indexesOfDuplicateAddressKeys.isEmpty()) {
            this.handleError(String.format(ADDRESSES_THAT_KEYS_NOT_UNIQUE, customerDraft.getKey(), indexesOfDuplicateAddressKeys));
            return false;
        }
        return true;
    }

    @Nonnull
    private List<Integer> getIndexes(@Nonnull List<BaseAddress> list, @Nonnull Predicate<BaseAddress> predicate) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (!predicate.test(list.get(i))) continue;
            indexes.add(i);
        }
        return indexes;
    }

    private boolean hasValidBillingAndShippingAddresses(@Nonnull CustomerDraft customerDraft) {
        List<Integer> invalidIndexes;
        List addressList = customerDraft.getAddresses();
        Predicate<Integer> isInvalidIndex = index -> index == null || addressList == null || addressList.isEmpty() || index < 0 || index > addressList.size() - 1;
        if (customerDraft.getBillingAddresses() != null && !customerDraft.getBillingAddresses().isEmpty() && !(invalidIndexes = this.getIndexValues(customerDraft.getBillingAddresses(), isInvalidIndex)).isEmpty()) {
            this.handleError(String.format(BILLING_ADDRESSES_ARE_NOT_VALID, customerDraft.getKey(), invalidIndexes));
            return false;
        }
        if (customerDraft.getShippingAddresses() != null && !customerDraft.getShippingAddresses().isEmpty() && !(invalidIndexes = this.getIndexValues(customerDraft.getShippingAddresses(), isInvalidIndex)).isEmpty()) {
            this.handleError(String.format(SHIPPING_ADDRESSES_ARE_NOT_VALID, customerDraft.getKey(), invalidIndexes));
            return false;
        }
        return true;
    }

    @Nonnull
    private List<Integer> getIndexValues(@Nonnull List<Integer> list, @Nonnull Predicate<Integer> predicate) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (Integer integer : list) {
            if (!predicate.test(integer)) continue;
            indexes.add(integer);
        }
        return indexes;
    }

    private void collectReferencedKeys(@Nonnull ReferencedKeys referencedKeys, @Nonnull CustomerDraft customerDraft) {
        this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)customerDraft.getCustomerGroup(), referencedKeys.customerGroupKeys::add);
        this.collectReferencedKeyFromCustomFieldsDraft(customerDraft.getCustom(), referencedKeys.typeKeys::add);
    }

    public static class ReferencedKeys {
        private final Set<String> customerGroupKeys = new HashSet<String>();
        private final Set<String> typeKeys = new HashSet<String>();

        public Set<String> getTypeKeys() {
            return this.typeKeys;
        }

        public Set<String> getCustomerGroupKeys() {
            return this.customerGroupKeys;
        }
    }
}

