/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.helpers;

import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventorySyncStatistics;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class InventoryBatchValidator
extends BaseBatchValidator<InventoryEntryDraft, InventorySyncOptions, InventorySyncStatistics> {
    static final String INVENTORY_DRAFT_SKU_NOT_SET = "InventoryEntryDraft doesn't have a SKU. Please make sure all inventory entry drafts have SKUs.";
    static final String INVENTORY_DRAFT_IS_NULL = "InventoryEntryDraft is null.";

    public InventoryBatchValidator(@Nonnull InventorySyncOptions syncOptions, @Nonnull InventorySyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<InventoryEntryDraft>, ReferencedKeys> validateAndCollectReferencedKeys(@Nonnull List<InventoryEntryDraft> inventoryDrafts) {
        ReferencedKeys referencedKeys = new ReferencedKeys();
        Set validDrafts = inventoryDrafts.stream().filter(this::isValidInventoryEntryDraft).peek(inventoryDraft -> this.collectReferencedKeys(referencedKeys, (InventoryEntryDraft)inventoryDraft)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, (Object)referencedKeys);
    }

    private boolean isValidInventoryEntryDraft(@Nullable InventoryEntryDraft inventoryDraft) {
        if (inventoryDraft == null) {
            this.handleError(INVENTORY_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)inventoryDraft.getSku())) {
            this.handleError(INVENTORY_DRAFT_SKU_NOT_SET);
        } else {
            return true;
        }
        return false;
    }

    private void collectReferencedKeys(@Nonnull ReferencedKeys referencedKeys, @Nonnull InventoryEntryDraft inventoryDraft) {
        this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)inventoryDraft.getSupplyChannel(), referencedKeys.channelKeys::add);
        this.collectReferencedKeyFromCustomFieldsDraft(inventoryDraft.getCustom(), referencedKeys.typeKeys::add);
    }

    public static class ReferencedKeys {
        private final Set<String> channelKeys = new HashSet<String>();
        private final Set<String> typeKeys = new HashSet<String>();

        public Set<String> getTypeKeys() {
            return this.typeKeys;
        }

        public Set<String> getChannelKeys() {
            return this.channelKeys;
        }
    }
}

