/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.product.Attribute;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductVariantDraft;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.commons.utils.CustomValueConverter;
import com.commercetools.sync.commons.utils.ResourceIdentifierUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.ProductSyncStatistics;
import com.commercetools.sync.products.utils.AttributeUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ProductBatchValidator
extends BaseBatchValidator<ProductDraft, ProductSyncOptions, ProductSyncStatistics> {
    static final String PRODUCT_DRAFT_KEY_NOT_SET = "ProductDraft with name: %s doesn't have a key. Please make sure all product drafts have keys.";
    static final String PRODUCT_DRAFT_IS_NULL = "ProductDraft is null.";
    static final String PRODUCT_MASTER_VARIANT_DRAFT_IS_NULL = "MasterVariant is null and Variants are not null for ProductDraft with key '%s'.";
    static final String PRODUCT_VARIANT_DRAFT_IS_NULL = "ProductVariantDraft at position '%d' of ProductDraft with key '%s' is null.";
    static final String PRODUCT_VARIANT_DRAFT_SKU_NOT_SET = "ProductVariantDraft at position '%d' of ProductDraft with key '%s' has no SKU set. Please make sure all variants have SKUs.";
    static final String PRODUCT_VARIANT_DRAFT_KEY_NOT_SET = "ProductVariantDraft at position '%d' of ProductDraft with key '%s' has no key set. Please make sure all variants have keys.";

    public ProductBatchValidator(@Nonnull ProductSyncOptions syncOptions, @Nonnull ProductSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<ProductDraft>, ReferencedKeys> validateAndCollectReferencedKeys(@Nonnull List<ProductDraft> productDrafts) {
        ReferencedKeys referencedKeys = new ReferencedKeys();
        Set validDrafts = productDrafts.stream().filter(this::isValidProductDraft).peek(productDraft -> this.collectReferencedKeys(referencedKeys, (ProductDraft)productDraft)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, (Object)referencedKeys);
    }

    private boolean isValidProductDraft(@Nullable ProductDraft productDraft) {
        if (productDraft == null) {
            this.handleError(PRODUCT_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)productDraft.getKey())) {
            this.handleError(String.format(PRODUCT_DRAFT_KEY_NOT_SET, productDraft.getName()));
        } else {
            List<String> draftErrors = this.getVariantDraftErrorsInAllVariants(productDraft);
            if (!draftErrors.isEmpty()) {
                draftErrors.forEach(this::handleError);
            } else {
                return true;
            }
        }
        return false;
    }

    private void collectReferencedKeys(@Nonnull ReferencedKeys referencedKeys, @Nonnull ProductDraft productDraft) {
        this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)productDraft.getProductType(), referencedKeys.productTypeKeys::add);
        this.collectReferencedKeysInCategories(referencedKeys, productDraft);
        this.collectReferencedKeysInVariants(referencedKeys, productDraft);
        this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)productDraft.getTaxCategory(), referencedKeys.taxCategoryKeys::add);
        this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)productDraft.getState(), referencedKeys.stateKeys::add);
    }

    private void collectReferencedKeysInCategories(@Nonnull ReferencedKeys referencedKeys, @Nonnull ProductDraft productDraft) {
        if (productDraft.getCategories() != null) {
            productDraft.getCategories().stream().filter(Objects::nonNull).forEach(resourceIdentifier -> this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)resourceIdentifier, referencedKeys.categoryKeys::add));
        }
    }

    private void collectReferencedKeysInVariants(@Nonnull ReferencedKeys referencedKeys, @Nonnull ProductDraft productDraft) {
        this.getAllVariants(productDraft).forEach(variantDraft -> {
            this.collectReferencedKeysInPrices(referencedKeys, (ProductVariantDraft)variantDraft);
            this.collectReferencedKeysInAttributes(referencedKeys, (ProductVariantDraft)variantDraft);
            this.collectReferencedKeysFromAssetDrafts(variantDraft.getAssets(), referencedKeys.typeKeys::add);
        });
    }

    @Nonnull
    private List<ProductVariantDraft> getAllVariants(@Nonnull ProductDraft productDraft) {
        ArrayList<ProductVariantDraft> allVariants = new ArrayList<ProductVariantDraft>();
        if (productDraft.getMasterVariant() != null) {
            allVariants.add(productDraft.getMasterVariant());
        }
        if (productDraft.getVariants() != null) {
            allVariants.addAll(productDraft.getVariants().stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return allVariants;
    }

    private void collectReferencedKeysInPrices(@Nonnull ReferencedKeys referencedKeys, @Nonnull ProductVariantDraft variantDraft) {
        if (variantDraft.getPrices() == null) {
            return;
        }
        variantDraft.getPrices().stream().filter(Objects::nonNull).forEach(priceDraft -> {
            this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)priceDraft.getCustomerGroup(), referencedKeys.customerGroupKeys::add);
            this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)priceDraft.getChannel(), referencedKeys.channelKeys::add);
            this.collectReferencedKeyFromCustomFieldsDraft(priceDraft.getCustom(), referencedKeys.typeKeys::add);
        });
    }

    private void collectReferencedKeysInAttributes(@Nonnull ReferencedKeys referencedKeys, @Nonnull ProductVariantDraft variantDraft) {
        referencedKeys.productKeys.addAll(ProductBatchValidator.getReferencedProductKeys(variantDraft));
        referencedKeys.categoryKeys.addAll(ProductBatchValidator.getReferencedKeysWithReferenceTypeId(variantDraft, "category"));
        referencedKeys.productTypeKeys.addAll(ProductBatchValidator.getReferencedKeysWithReferenceTypeId(variantDraft, "product-type"));
        referencedKeys.customObjectCompositeIdentifiers.addAll(ProductBatchValidator.getReferencedKeysWithReferenceTypeId(variantDraft, "key-value-document"));
    }

    @Nonnull
    private List<String> getVariantDraftErrorsInAllVariants(@Nonnull ProductDraft productDraft) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ProductVariantDraft masterVariant = productDraft.getMasterVariant();
        List variants = productDraft.getVariants();
        if (masterVariant == null) {
            if (variants != null && !variants.isEmpty()) {
                errorMessages.add(String.format(PRODUCT_MASTER_VARIANT_DRAFT_IS_NULL, productDraft.getKey()));
            }
            return errorMessages;
        }
        ArrayList<ProductVariantDraft> allVariants = new ArrayList<ProductVariantDraft>();
        allVariants.add(masterVariant);
        if (variants != null) {
            allVariants.addAll(variants);
        }
        for (int i = 0; i < allVariants.size(); ++i) {
            errorMessages.addAll(this.getVariantDraftErrorsInAllVariants((ProductVariantDraft)allVariants.get(i), i, Objects.requireNonNull(productDraft.getKey())));
        }
        return errorMessages;
    }

    @Nonnull
    private List<String> getVariantDraftErrorsInAllVariants(@Nullable ProductVariantDraft productVariantDraft, int variantPosition, @Nonnull String productDraftKey) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (productVariantDraft != null) {
            if (StringUtils.isBlank((CharSequence)productVariantDraft.getKey())) {
                errorMessages.add(String.format(PRODUCT_VARIANT_DRAFT_KEY_NOT_SET, variantPosition, productDraftKey));
            }
            if (StringUtils.isBlank((CharSequence)productVariantDraft.getSku())) {
                errorMessages.add(String.format(PRODUCT_VARIANT_DRAFT_SKU_NOT_SET, variantPosition, productDraftKey));
            }
        } else {
            errorMessages.add(String.format(PRODUCT_VARIANT_DRAFT_IS_NULL, variantPosition, productDraftKey));
        }
        return errorMessages;
    }

    @Nonnull
    public static Set<String> getReferencedProductKeys(@Nonnull ProductVariantDraft variantDraft) {
        return ProductBatchValidator.getReferencedKeysWithReferenceTypeId(variantDraft, "product");
    }

    private static Set<String> getReferencedKeysWithReferenceTypeId(@Nonnull ProductVariantDraft variantDraft, @Nonnull String referenceTypeId) {
        List attributes = variantDraft.getAttributes();
        if (attributes == null) {
            return Collections.emptySet();
        }
        return attributes.stream().filter(Objects::nonNull).map(attribute -> ProductBatchValidator.getReferencedKeysWithReferenceTypeId(attribute, referenceTypeId)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    private static Set<String> getReferencedKeysWithReferenceTypeId(@Nonnull Attribute attribute, @Nonnull String referenceTypeId) {
        JsonNode attributeValueAsJson = AttributeUtils.replaceAttributeValueWithJsonAndReturnValue(attribute);
        List<JsonNode> allAttributeReferences = AttributeUtils.getAttributeReferences(attributeValueAsJson);
        if (allAttributeReferences.isEmpty()) {
            return Collections.emptySet();
        }
        return allAttributeReferences.stream().filter(reference -> ResourceIdentifierUtils.isReferenceOfType(reference, referenceTypeId)).map(reference -> reference.get("id")).filter(field -> CustomValueConverter.isValidTextNode(field)).map(field -> field.asText()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static class ReferencedKeys {
        private final Set<String> productKeys = new HashSet<String>();
        private final Set<String> productTypeKeys = new HashSet<String>();
        private final Set<String> categoryKeys = new HashSet<String>();
        private final Set<String> taxCategoryKeys = new HashSet<String>();
        private final Set<String> stateKeys = new HashSet<String>();
        private final Set<String> typeKeys = new HashSet<String>();
        private final Set<String> channelKeys = new HashSet<String>();
        private final Set<String> customerGroupKeys = new HashSet<String>();
        private final Set<String> customObjectCompositeIdentifiers = new HashSet<String>();

        public Set<String> getProductKeys() {
            return this.productKeys;
        }

        public Set<String> getProductTypeKeys() {
            return this.productTypeKeys;
        }

        public Set<String> getCategoryKeys() {
            return this.categoryKeys;
        }

        public Set<String> getTaxCategoryKeys() {
            return this.taxCategoryKeys;
        }

        public Set<String> getStateKeys() {
            return this.stateKeys;
        }

        public Set<String> getTypeKeys() {
            return this.typeKeys;
        }

        public Set<String> getChannelKeys() {
            return this.channelKeys;
        }

        public Set<String> getCustomerGroupKeys() {
            return this.customerGroupKeys;
        }

        public Set<CustomObjectCompositeIdentifier> getCustomObjectCompositeIdentifiers() {
            if (!this.customObjectCompositeIdentifiers.isEmpty()) {
                return this.customObjectCompositeIdentifiers.stream().map(identifierAsString -> {
                    if (SyncUtils.isUuid(identifierAsString)) {
                        return null;
                    }
                    try {
                        return CustomObjectCompositeIdentifier.of(identifierAsString);
                    }
                    catch (IllegalArgumentException ignored) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
    }
}

