/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.channel.ChannelReference;
import com.commercetools.api.models.channel.ChannelResourceIdentifier;
import com.commercetools.api.models.channel.ChannelResourceIdentifierBuilder;
import com.commercetools.api.models.common.DiscountedPrice;
import com.commercetools.api.models.common.DiscountedPriceDraft;
import com.commercetools.api.models.common.DiscountedPriceDraftBuilder;
import com.commercetools.api.models.common.Money;
import com.commercetools.api.models.common.Price;
import com.commercetools.api.models.common.PriceDraft;
import com.commercetools.api.models.common.PriceDraftBuilder;
import com.commercetools.api.models.common.PriceTier;
import com.commercetools.api.models.common.PriceTierDraft;
import com.commercetools.api.models.common.PriceTierDraftBuilder;
import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.customer_group.CustomerGroupReference;
import com.commercetools.api.models.customer_group.CustomerGroupResourceIdentifier;
import com.commercetools.api.models.customer_group.CustomerGroupResourceIdentifierBuilder;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.utils.CustomFieldsUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class PriceUtils {
    public static List<PriceDraft> createPriceDraft(@Nullable List<Price> prices) {
        return PriceUtils.createPriceDraft(prices, null);
    }

    public static List<PriceDraft> createPriceDraft(@Nullable List<Price> prices, @Nullable ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (prices == null) {
            return Collections.emptyList();
        }
        return prices.stream().map(price -> PriceDraftBuilder.of().channel(PriceUtils.createChannelResourceIdentifier(price.getChannel(), referenceIdToKeyCache)).country(price.getCountry()).custom(CustomFieldsUtils.createCustomFieldsDraft(price.getCustom(), referenceIdToKeyCache)).customerGroup(PriceUtils.createCustomerGroupResourceIdentifier(price.getCustomerGroup(), referenceIdToKeyCache)).discounted(PriceUtils.createDiscountedPriceDraft(price.getDiscounted())).key(price.getKey()).validFrom(price.getValidFrom()).validUntil(price.getValidUntil()).tiers(PriceUtils.createPriceTierDraft(price.getTiers())).value((Money)price.getValue()).build()).collect(Collectors.toList());
    }

    private static ChannelResourceIdentifier createChannelResourceIdentifier(@Nullable ChannelReference channelReference, @Nullable ReferenceIdToKeyCache referenceIdToKeyCache) {
        ChannelResourceIdentifier channelResourceIdentifier = null;
        if (referenceIdToKeyCache != null) {
            channelResourceIdentifier = SyncUtils.getResourceIdentifierWithKey((Reference)channelReference, referenceIdToKeyCache, (id, key) -> ChannelResourceIdentifierBuilder.of().key(key).id(id).build());
        } else if (channelReference != null) {
            channelResourceIdentifier = ChannelResourceIdentifierBuilder.of().id(channelReference.getId()).build();
        }
        return channelResourceIdentifier;
    }

    private static CustomerGroupResourceIdentifier createCustomerGroupResourceIdentifier(@Nullable CustomerGroupReference customerGroupReference, @Nullable ReferenceIdToKeyCache referenceIdToKeyCache) {
        CustomerGroupResourceIdentifier customerGroupResourceIdentifier = null;
        if (referenceIdToKeyCache != null) {
            customerGroupResourceIdentifier = SyncUtils.getResourceIdentifierWithKey((Reference)customerGroupReference, referenceIdToKeyCache, (id, key) -> CustomerGroupResourceIdentifierBuilder.of().id(id).key(key).build());
        } else if (customerGroupReference != null) {
            customerGroupResourceIdentifier = CustomerGroupResourceIdentifierBuilder.of().id(customerGroupReference.getId()).build();
        }
        return customerGroupResourceIdentifier;
    }

    private static DiscountedPriceDraft createDiscountedPriceDraft(@Nullable DiscountedPrice discountedPrice) {
        return Optional.ofNullable(discountedPrice).map(price -> DiscountedPriceDraftBuilder.of().discount(price.getDiscount()).value((Money)price.getValue()).build()).orElse(null);
    }

    public static List<PriceTierDraft> createPriceTierDraft(@Nullable List<PriceTier> priceTiers) {
        if (priceTiers == null) {
            return null;
        }
        return priceTiers.stream().map(priceTier -> Optional.ofNullable(priceTier).map(tier -> PriceTierDraftBuilder.of().minimumQuantity(tier.getMinimumQuantity()).value((Money)tier.getValue()).build()).orElse(null)).collect(Collectors.toList());
    }
}

