/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.common.Image;
import com.commercetools.api.models.common.Price;
import com.commercetools.api.models.product.Attribute;
import com.commercetools.api.models.product.ProductAddExternalImageAction;
import com.commercetools.api.models.product.ProductAddPriceAction;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductMoveImageToPositionAction;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductRemoveImageAction;
import com.commercetools.api.models.product.ProductRemovePriceActionBuilder;
import com.commercetools.api.models.product.ProductSetAttributeAction;
import com.commercetools.api.models.product.ProductSetAttributeInAllVariantsAction;
import com.commercetools.api.models.product.ProductSetSkuAction;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.api.models.product.ProductVariant;
import com.commercetools.api.models.product.ProductVariantDraft;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.AssetsUpdateActionUtils;
import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.PriceCompositeId;
import com.commercetools.sync.products.helpers.ProductAssetActionFactory;
import com.commercetools.sync.products.utils.ProductVariantAttributeUpdateActionUtils;
import com.commercetools.sync.products.utils.ProductVariantPriceUpdateActionUtils;
import com.commercetools.sync.products.utils.UnorderedCollectionSyncUtils;
import com.commercetools.sync.products.utils.UpdateActionsSortUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductVariantUpdateActionUtils {
    public static final String FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION = "Failed to build a setAttribute/setAttributeInAllVariants update action for the attribute with the name '%s' in the ProductVariantDraft with key '%s' on the product with key '%s'. Reason: %s";
    public static final String NULL_PRODUCT_VARIANT_ATTRIBUTE = "AttributeDraft is null.";
    private static final String NULL_PRODUCT_VARIANT_PRICE = "New price is null.";

    @Nonnull
    public static Optional<ProductUpdateAction> buildProductVariantSkuUpdateAction(@Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant) {
        String oldProductVariantSku = oldProductVariant.getSku();
        String newProductVariantSku = newProductVariant.getSku();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldProductVariantSku, newProductVariantSku, () -> ProductSetSkuAction.builder().variantId(oldProductVariant.getId()).sku(newProductVariantSku).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static List<ProductUpdateAction> buildProductVariantPricesUpdateActions(@Nullable ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull ProductSyncOptions syncOptions) {
        List oldPrices = oldProductVariant.getPrices();
        List newPrices = newProductVariant.getPrices();
        List<ProductUpdateAction> updateActions = UnorderedCollectionSyncUtils.buildRemoveUpdateActions(oldPrices, newPrices, PriceCompositeId::of, PriceCompositeId::of, price -> ProductRemovePriceActionBuilder.of().priceId(price.getId()).staged(Boolean.valueOf(true)).build());
        Long variantId = oldProductVariant.getId();
        Map<PriceCompositeId, Price> oldPricesMap = CollectionUtils.collectionToMap(oldPrices, PriceCompositeId::of);
        CollectionUtils.emptyIfNull(newPrices).forEach(newPrice -> {
            if (newPrice == null) {
                syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build prices update actions for one price on the variant with id '%d' and key '%s'. Reason: %s", variantId, oldProductVariant.getKey(), NULL_PRODUCT_VARIANT_PRICE)), oldProduct, newProduct, null);
            } else {
                PriceCompositeId newPriceCompositeId = PriceCompositeId.of(newPrice);
                Price matchingOldPrice = (Price)oldPricesMap.get(newPriceCompositeId);
                List updateOrAddPrice = Optional.ofNullable(matchingOldPrice).map(oldPrice -> ProductVariantPriceUpdateActionUtils.buildActions(newProduct, variantId, oldPrice, newPrice, syncOptions)).orElseGet(() -> Collections.singletonList(ProductAddPriceAction.builder().variantId(variantId).price(newPrice).staged(Boolean.valueOf(true)).build()));
                updateActions.addAll(updateOrAddPrice);
            }
        });
        return UpdateActionsSortUtils.sortPriceActions(updateActions);
    }

    @Nonnull
    public static List<ProductUpdateAction> buildProductVariantImagesUpdateActions(@Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant) {
        List newProductVariantImages;
        ArrayList<ProductUpdateAction> updateActions = new ArrayList<ProductUpdateAction>();
        Long oldProductVariantId = oldProductVariant.getId();
        List oldProductVariantImages = oldProductVariant.getImages();
        if (!Objects.equals(oldProductVariantImages, newProductVariantImages = newProductVariant.getImages())) {
            ArrayList<Image> updatedOldImages = new ArrayList<Image>(oldProductVariantImages);
            List<Image> newImages = CollectionUtils.emptyIfNull(newProductVariantImages);
            CollectionUtils.filterCollection(oldProductVariantImages, oldVariantImage -> !newImages.contains(oldVariantImage)).forEach(oldImage -> {
                updateActions.add((ProductUpdateAction)ProductRemoveImageAction.builder().variantId(oldProductVariantId).imageUrl(oldImage.getUrl()).staged(Boolean.valueOf(true)).build());
                updatedOldImages.remove(oldImage);
            });
            CollectionUtils.filterCollection(newProductVariantImages, newVariantImage -> !oldProductVariantImages.contains(newVariantImage)).forEach(newImage -> {
                updateActions.add((ProductUpdateAction)ProductAddExternalImageAction.builder().variantId(oldProductVariantId).image(newImage).staged(Boolean.valueOf(true)).build());
                updatedOldImages.add((Image)newImage);
            });
            updateActions.addAll(ProductVariantUpdateActionUtils.buildMoveImageToPositionUpdateActions(oldProductVariantId, updatedOldImages, newImages));
        }
        return updateActions;
    }

    public static List<ProductMoveImageToPositionAction> buildMoveImageToPositionUpdateActions(long variantId, @Nonnull List<Image> oldImages, @Nonnull List<Image> newImages) {
        int newImageListSize;
        int oldImageListSize = oldImages.size();
        if (oldImageListSize != (newImageListSize = newImages.size())) {
            throw new IllegalArgumentException(String.format("Old and new image lists must have the same size, but they have %d and %d respectively", oldImageListSize, newImageListSize));
        }
        HashMap<Image, Long> imageIndexMap = new HashMap<Image, Long>(oldImageListSize);
        long index = 0L;
        for (Image newImage : newImages) {
            imageIndexMap.put(newImage, index++);
        }
        ArrayList<ProductMoveImageToPositionAction> updateActions = new ArrayList<ProductMoveImageToPositionAction>();
        for (int oldIndex = 0; oldIndex < oldImageListSize; ++oldIndex) {
            Image oldImage = oldImages.get(oldIndex);
            Long newIndex = Optional.ofNullable((Long)imageIndexMap.get(oldImage)).orElseThrow(() -> new IllegalArgumentException(String.format("Old image [%s] not found in the new images list.", oldImage)));
            if ((long)oldIndex == newIndex) continue;
            updateActions.add(ProductMoveImageToPositionAction.builder().imageUrl(oldImage.getUrl()).variantId(Long.valueOf(variantId)).position(newIndex).staged(Boolean.valueOf(true)).build());
        }
        return updateActions;
    }

    @Nonnull
    public static List<ProductUpdateAction> buildProductVariantAssetsUpdateActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull ProductSyncOptions syncOptions) {
        try {
            return AssetsUpdateActionUtils.buildAssetsUpdateActions(newProduct, oldProductVariant.getAssets(), newProductVariant.getAssets(), new ProductAssetActionFactory(oldProductVariant.getId(), syncOptions), syncOptions);
        }
        catch (BuildUpdateActionException exception) {
            SyncException syncException = new SyncException(String.format("Failed to build update actions for the assets of the product variant with the sku '%s'. Reason: %s", oldProductVariant.getSku(), exception), exception);
            syncOptions.applyErrorCallback(syncException, oldProduct, newProduct, null);
            return Collections.emptyList();
        }
    }

    @Nonnull
    public static List<ProductUpdateAction> buildProductVariantAttributesUpdateActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull Map<String, AttributeMetaData> attributesMetaData, @Nonnull ProductSyncOptions syncOptions) {
        String productKey = oldProduct.getKey();
        long oldProductVariantId = oldProductVariant.getId();
        List newProductVariantAttributes = newProductVariant.getAttributes();
        List oldProductVariantAttributes = oldProductVariant.getAttributes();
        List<ProductUpdateAction> updateActions = UnorderedCollectionSyncUtils.buildRemoveUpdateActions(oldProductVariantAttributes, newProductVariantAttributes, Attribute::getName, Attribute::getName, attribute -> {
            try {
                return ProductVariantUpdateActionUtils.buildUnSetAttribute(oldProductVariantId, attribute.getName(), attributesMetaData);
            }
            catch (BuildUpdateActionException buildUpdateActionException) {
                String errorMessage = String.format(FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION, attribute.getName(), newProductVariant.getKey(), productKey, buildUpdateActionException.getMessage());
                syncOptions.applyErrorCallback(new SyncException(errorMessage, new BuildUpdateActionException(errorMessage, buildUpdateActionException)), oldProduct, newProduct, null);
                return null;
            }
        });
        Map<String, Attribute> oldAttributesMap = CollectionUtils.collectionToMap(oldProductVariantAttributes, Attribute::getName);
        CollectionUtils.emptyIfNull(newProductVariantAttributes).forEach(newAttribute -> {
            if (newAttribute == null) {
                String errorMessage = String.format(FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION, null, newProductVariant.getKey(), productKey, NULL_PRODUCT_VARIANT_ATTRIBUTE);
                syncOptions.applyErrorCallback(new SyncException(errorMessage, new BuildUpdateActionException(errorMessage)), oldProduct, newProduct, updateActions);
            } else {
                String newAttributeName = newAttribute.getName();
                Attribute matchingOldAttribute = (Attribute)oldAttributesMap.get(newAttributeName);
                try {
                    ProductVariantAttributeUpdateActionUtils.buildProductVariantAttributeUpdateAction(oldProductVariantId, matchingOldAttribute, newAttribute, attributesMetaData).ifPresent(updateActions::add);
                }
                catch (BuildUpdateActionException buildUpdateActionException) {
                    String errorMessage = String.format(FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION, newAttributeName, newProductVariant.getKey(), productKey, buildUpdateActionException.getMessage());
                    syncOptions.applyErrorCallback(new SyncException(errorMessage, new BuildUpdateActionException(errorMessage, buildUpdateActionException)));
                }
            }
        });
        return updateActions;
    }

    private static ProductUpdateAction buildUnSetAttribute(@Nonnull long variantId, @Nonnull String attributeName, @Nonnull Map<String, AttributeMetaData> attributesMetaData) throws BuildUpdateActionException {
        AttributeMetaData attributeMetaData = attributesMetaData.get(attributeName);
        if (attributeMetaData == null) {
            String errorMessage = String.format("Cannot find the attribute with the name '%s' in the supplied attribute metadata.", attributeName);
            throw new BuildUpdateActionException(errorMessage);
        }
        return attributeMetaData.isSameForAll() ? ProductSetAttributeInAllVariantsAction.builder().name(attributeName).value(null).staged(Boolean.valueOf(true)).build() : ProductSetAttributeAction.builder().variantId(Long.valueOf(variantId)).name(attributeName).value(null).staged(Boolean.valueOf(true)).build();
    }

    private ProductVariantUpdateActionUtils() {
    }
}

