/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.product.ProductAddPriceAction;
import com.commercetools.api.models.product.ProductRemovePriceAction;
import com.commercetools.api.models.product.ProductUpdateAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class UpdateActionsSortUtils {
    @Nonnull
    public static List<ProductUpdateAction> sortPriceActions(@Nonnull List<ProductUpdateAction> updateActions) {
        ArrayList<ProductUpdateAction> actionsCopy = new ArrayList<ProductUpdateAction>(updateActions);
        actionsCopy.sort((action1, action2) -> {
            if (action1 instanceof ProductRemovePriceAction && !(action2 instanceof ProductRemovePriceAction)) {
                return -1;
            }
            if (!(action1 instanceof ProductRemovePriceAction) && action2 instanceof ProductRemovePriceAction) {
                return 1;
            }
            if (!(action1 instanceof ProductAddPriceAction) && action2 instanceof ProductAddPriceAction) {
                return -1;
            }
            if (action1 instanceof ProductAddPriceAction && !(action2 instanceof ProductAddPriceAction)) {
                return 1;
            }
            return 0;
        });
        return actionsCopy;
    }

    private UpdateActionsSortUtils() {
    }
}

