/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.api.models.product_type.AttributeDefinitionDraft;
import com.commercetools.api.models.product_type.AttributeNestedType;
import com.commercetools.api.models.product_type.AttributeNestedTypeBuilder;
import com.commercetools.api.models.product_type.AttributeSetType;
import com.commercetools.api.models.product_type.AttributeSetTypeBuilder;
import com.commercetools.api.models.product_type.AttributeType;
import com.commercetools.api.models.product_type.ProductType;
import com.commercetools.api.models.product_type.ProductTypeDraft;
import com.commercetools.api.models.product_type.ProductTypeReference;
import com.commercetools.api.models.product_type.ProductTypeReferenceBuilder;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.producttypes.helpers.ResourceToDraftConverters;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductTypeReferenceResolutionUtils {
    @Nonnull
    public static List<ProductTypeDraft> mapToProductTypeDrafts(@Nonnull List<ProductType> productTypes, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return productTypes.stream().filter(Objects::nonNull).map(productType -> {
            List<AttributeDefinitionDraft> referenceReplacedAttributeDefinitions = ProductTypeReferenceResolutionUtils.replaceAttributeDefinitionsReferenceIdsWithKeys(productType, referenceIdToKeyCache);
            return ResourceToDraftConverters.toProductTypeDraftBuilder(productType).attributes(referenceReplacedAttributeDefinitions).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    private static List<AttributeDefinitionDraft> replaceAttributeDefinitionsReferenceIdsWithKeys(@Nonnull ProductType productType, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return productType.getAttributes().stream().map(attributeDefinition -> {
            AttributeType attributeType = attributeDefinition.getType();
            AttributeType referenceReplacedType = ProductTypeReferenceResolutionUtils.replaceIdWithKeyForProductTypeReference(attributeType, referenceIdToKeyCache);
            return ResourceToDraftConverters.toAttributeDefinitionDraftBuilder(attributeDefinition).type(referenceReplacedType).build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nonnull
    private static AttributeType replaceIdWithKeyForProductTypeReference(@Nonnull AttributeType attributeType, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (attributeType instanceof AttributeNestedType) {
            ProductTypeReference referenceReplacedNestedType = ProductTypeReferenceResolutionUtils.replaceIdWithKeyForProductTypeReference((AttributeNestedType)attributeType, referenceIdToKeyCache);
            return AttributeNestedTypeBuilder.of().typeReference(referenceReplacedNestedType).build();
        }
        if (attributeType instanceof AttributeSetType) {
            AttributeSetType setAttributeType = (AttributeSetType)attributeType;
            AttributeType elementType = setAttributeType.getElementType();
            AttributeType referenceReplacedElementType = ProductTypeReferenceResolutionUtils.replaceIdWithKeyForProductTypeReference(elementType, referenceIdToKeyCache);
            return AttributeSetTypeBuilder.of().elementType(referenceReplacedElementType).build();
        }
        return attributeType;
    }

    @Nonnull
    private static ProductTypeReference replaceIdWithKeyForProductTypeReference(@Nonnull AttributeNestedType nestedAttributeType, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        ProductTypeReference productTypeReference = nestedAttributeType.getTypeReference();
        String productTypeId = productTypeReference.getId();
        String productTypeKey = referenceIdToKeyCache.get(productTypeId);
        if (null != productTypeKey) {
            return ProductTypeReferenceBuilder.of().id(productTypeKey).build();
        }
        return productTypeReference;
    }

    private ProductTypeReferenceResolutionUtils() {
    }
}

