/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.PagedQueryResourceRequest;
import com.commercetools.api.client.QueryUtils;
import com.commercetools.api.models.DomainResource;
import com.commercetools.api.models.ResourcePagedQueryResponse;
import com.commercetools.api.models.graph_ql.GraphQLRequestBuilder;
import com.commercetools.api.models.graph_ql.GraphQLResponse;
import com.commercetools.api.models.graph_ql.GraphQLVariablesMapBuilder;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ApiMethod;
import io.vrap.rmf.base.client.BodyApiMethod;
import io.vrap.rmf.base.client.Draft;
import io.vrap.rmf.base.client.error.NotFoundException;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

abstract class BaseService<SyncOptionsT extends BaseSyncOptions, ResourceT extends DomainResource<ResourceT>, ResourceDraftT extends Draft<ResourceDraftT>, PagedQueryRequestT extends PagedQueryResourceRequest<PagedQueryRequestT, PagedQueryResponseT, QueryBuilderDslT>, PagedQueryResponseT extends ResourcePagedQueryResponse<ResourceT>, GetOneResourceQueryT extends ApiMethod<GetOneResourceQueryT, ResourceT>, QueryResultT, QueryBuilderDslT, PostRequestT extends BodyApiMethod<PostRequestT, QueryResultT, ResourceDraftT>> {
    final SyncOptionsT syncOptions;
    protected final Cache<String, String> keyToIdCache;
    protected static final int MAXIMUM_ALLOWED_UPDATE_ACTIONS = 500;
    static final String CREATE_FAILED = "Failed to create draft with key: '%s'. Reason: %s";
    static final int CHUNK_SIZE = 250;

    BaseService(@Nonnull SyncOptionsT syncOptions) {
        this.syncOptions = syncOptions;
        this.keyToIdCache = Caffeine.newBuilder().maximumSize(((BaseSyncOptions)syncOptions).getCacheSize()).executor(Runnable::run).build();
    }

    @Nonnull
    protected Set<String> getKeysNotCached(@Nonnull Set<String> keys) {
        return keys.stream().filter(StringUtils::isNotBlank).filter(key -> !this.keyToIdCache.asMap().containsKey(key)).collect(Collectors.toSet());
    }

    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIdsUsingGraphQl(@Nonnull Set<String> keysToCache, @Nonnull GraphQlQueryResource queryResource) {
        Set<String> keysNotCached = this.getKeysNotCached(keysToCache);
        if (keysNotCached.isEmpty()) {
            return CompletableFuture.completedFuture(this.keyToIdCache.asMap());
        }
        List<List<String>> chunkedKeys = ChunkUtils.chunk(keysNotCached, 250);
        String query = String.format("query fetchIdKeyPairs($where: String, $limit: Int) {%n  %s(limit: $limit, where: $where) {%n    results {%n      id%n      key%n    }%n  }%n}", queryResource.getName());
        List graphQLRequests = chunkedKeys.stream().map(keys -> keys.stream().filter(key -> !StringUtils.isBlank((CharSequence)key)).map(StringEscapeUtils::escapeJava).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "))).map(commaSeparatedKeys -> String.format("key in (%s)", commaSeparatedKeys)).map(whereQuery -> GraphQLVariablesMapBuilder.of().addValue("where", whereQuery).addValue("limit", (Object)250).build()).map(variables -> GraphQLRequestBuilder.of().query(query).variables(variables).build()).collect(Collectors.toList());
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(graphQLRequests.stream().map(graphQLRequest -> ((BaseSyncOptions)this.syncOptions).getCtpClient().graphql().post(graphQLRequest).execute()).collect(Collectors.toList()), Collectors.toList()).thenApply(graphQlResults -> {
            graphQlResults.stream().map(ApiHttpResponse::getBody).filter(Objects::nonNull).map(GraphQLResponse::getData).filter(Objects::nonNull).forEach(data -> {
                ObjectMapper objectMapper = JsonUtils.getConfiguredObjectMapper();
                JsonNode jsonNode = (JsonNode)objectMapper.convertValue(data, JsonNode.class);
                Iterator elements = jsonNode.get(queryResource.getName()).get("results").elements();
                while (elements.hasNext()) {
                    JsonNode idAndKey = (JsonNode)elements.next();
                    this.keyToIdCache.put((Object)idAndKey.get("key").asText(), (Object)idAndKey.get("id").asText());
                }
            });
            return this.keyToIdCache.asMap();
        });
    }

    @Nonnull
    CompletionStage<Optional<String>> fetchCachedResourceId(@Nullable String key, @Nonnull Function<ResourceT, String> keyMapper, @Nonnull PagedQueryRequestT query) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        String id = (String)this.keyToIdCache.getIfPresent((Object)key);
        if (id != null) {
            return CompletableFuture.completedFuture(Optional.of(id));
        }
        return this.fetchAndCache(key, keyMapper, query);
    }

    private CompletionStage<Optional<String>> fetchAndCache(@Nullable String key, @Nonnull Function<ResourceT, String> keyMapper, @Nonnull PagedQueryRequestT query) {
        Consumer<List> pageConsumer = page -> page.forEach(resource -> this.keyToIdCache.put((Object)((String)keyMapper.apply(resource)), (Object)resource.getId()));
        return QueryUtils.queryAll(query, pageConsumer).thenApply(result -> Optional.ofNullable((String)this.keyToIdCache.getIfPresent((Object)key)));
    }

    @Nonnull
    CompletionStage<Optional<ResourceT>> createResource(@Nonnull ResourceDraftT draft, @Nonnull Function<ResourceDraftT, String> keyMapper, @Nonnull Function<QueryResultT, String> idMapper, @Nonnull Function<QueryResultT, ResourceT> resourceMapper, @Nonnull Supplier<PostRequestT> createCommand) {
        String draftKey = keyMapper.apply(draft);
        if (StringUtils.isBlank((CharSequence)draftKey)) {
            ((BaseSyncOptions)this.syncOptions).applyErrorCallback(new SyncException(String.format(CREATE_FAILED, draftKey, "Draft key is blank!")), null, draft, null);
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return this.executeCreateCommand(draft, draftKey, idMapper, resourceMapper, (BodyApiMethod)createCommand.get());
    }

    @Nonnull
    CompletionStage<Optional<ResourceT>> executeCreateCommand(@Nonnull ResourceDraftT draft, @Nonnull String key, @Nonnull Function<QueryResultT, String> idMapper, @Nonnull Function<QueryResultT, ResourceT> resourceMapper, @Nonnull PostRequestT createCommand) {
        return createCommand.execute().handle((result, exception) -> {
            if (exception != null) {
                ((BaseSyncOptions)this.syncOptions).applyErrorCallback(new SyncException(String.format(CREATE_FAILED, key, exception.getMessage()), (Throwable)exception), null, (Draft)draft, null);
                return Optional.empty();
            }
            if (result != null) {
                Object resultBody = result.getBody();
                this.keyToIdCache.put((Object)key, (Object)((String)idMapper.apply(resultBody)));
                return Optional.of((DomainResource)resourceMapper.apply(resultBody));
            }
            return Optional.empty();
        });
    }

    CompletionStage<Set<ResourceT>> fetchMatchingResources(@Nonnull Set<String> keys, @Nonnull Function<ResourceT, String> keyMapper, @Nonnull Function<Set<String>, PagedQueryRequestT> keysQueryMapper) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        return this.fetchWithChunks(keysQueryMapper, keys).thenApply(chunk -> {
            HashSet returnedSet = new HashSet();
            chunk.forEach(response -> {
                ResourcePagedQueryResponse responseBody = (ResourcePagedQueryResponse)response.getBody();
                responseBody.getResults().forEach(resource -> {
                    returnedSet.add(resource);
                    this.keyToIdCache.put((Object)((String)keyMapper.apply(resource)), (Object)resource.getId());
                });
            });
            return returnedSet;
        });
    }

    private CompletableFuture<List<ApiHttpResponse<PagedQueryResponseT>>> fetchWithChunks(@Nonnull Function<Set<String>, PagedQueryRequestT> keysQueryMapper, @Nonnull Set<String> keysNotCached) {
        List<List<String>> chunkedKeys = ChunkUtils.chunk(keysNotCached, 250);
        List keysQueryMapperList = chunkedKeys.stream().map(_keys -> ((PagedQueryResourceRequest)keysQueryMapper.apply(new HashSet(_keys))).withLimit((Object)250).withWithTotal((Object)false)).collect(Collectors.toList());
        return ChunkUtils.executeChunks(keysQueryMapperList);
    }

    @Nonnull
    CompletionStage<Optional<ResourceT>> fetchResource(@Nullable String key, @Nonnull GetOneResourceQueryT query) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return ((CompletableFuture)((CompletableFuture)query.execute().thenApply(ApiHttpResponse::getBody)).thenApply(resource -> {
            this.keyToIdCache.put((Object)key, (Object)resource.getId());
            return Optional.of(resource);
        })).exceptionally(exception -> {
            if (exception != null && exception.getCause() instanceof NotFoundException) {
                return Optional.empty();
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new CompletionException((Throwable)exception);
        });
    }
}

