/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyCategoriesGet;
import com.commercetools.api.client.ByProjectKeyCategoriesKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyCategoriesPost;
import com.commercetools.api.models.category.Category;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategoryPagedQueryResponse;
import com.commercetools.api.models.category.CategoryUpdateAction;
import com.commercetools.api.models.category.CategoryUpdateBuilder;
import com.commercetools.api.predicates.query.category.CategoryQueryBuilderDsl;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.impl.BaseService;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CategoryServiceImpl
extends BaseService<CategorySyncOptions, Category, CategoryDraft, ByProjectKeyCategoriesGet, CategoryPagedQueryResponse, ByProjectKeyCategoriesKeyByKeyGet, Category, CategoryQueryBuilderDsl, ByProjectKeyCategoriesPost>
implements CategoryService {
    public CategoryServiceImpl(@Nonnull CategorySyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> categoryKeys) {
        return super.cacheKeysToIdsUsingGraphQl(categoryKeys, GraphQlQueryResource.CATEGORIES);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Category>> fetchMatchingCategoriesByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, categories -> categories.getKey(), keysNotCached -> ((CategorySyncOptions)this.syncOptions).getCtpClient().categories().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Category>> fetchCategory(@Nullable String key) {
        ByProjectKeyCategoriesKeyByKeyGet byProjectKeyCategoriesKeyByKeyGet = ((CategorySyncOptions)this.syncOptions).getCtpClient().categories().withKey(key).get();
        return super.fetchResource(key, byProjectKeyCategoriesKeyByKeyGet);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCategoryId(@Nonnull String key) {
        ByProjectKeyCategoriesGet query = ((CategorySyncOptions)this.syncOptions).getCtpClient().categories().get().withWhere((Object)"key in :keys").withPredicateVar("keys", Collections.singletonList(key));
        return this.fetchCachedResourceId(key, query);
    }

    @Nonnull
    CompletionStage<Optional<String>> fetchCachedResourceId(@Nullable String key, @Nonnull ByProjectKeyCategoriesGet query) {
        return this.fetchCachedResourceId(key, resource -> resource.getKey(), query);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Category>> createCategory(@Nonnull CategoryDraft categoryDraft) {
        return super.createResource(categoryDraft, CategoryDraft::getKey, Category::getId, Function.identity(), () -> ((CategorySyncOptions)this.syncOptions).getCtpClient().categories().post(categoryDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<Category> updateCategory(@Nonnull Category category, @Nonnull List<CategoryUpdateAction> updateActions) {
        List<List<CategoryUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)category));
        for (List<CategoryUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedCategory -> ((CategorySyncOptions)this.syncOptions).getCtpClient().categories().withId(updatedCategory.getId()).post(CategoryUpdateBuilder.of().actions(batch).version(updatedCategory.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }
}

