/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyCustomObjectsByContainerByKeyGet;
import com.commercetools.api.client.ByProjectKeyCustomObjectsGet;
import com.commercetools.api.client.ByProjectKeyCustomObjectsPost;
import com.commercetools.api.models.custom_object.CustomObject;
import com.commercetools.api.models.custom_object.CustomObjectDraft;
import com.commercetools.api.models.custom_object.CustomObjectPagedQueryResponse;
import com.commercetools.api.predicates.query.custom_object.CustomObjectQueryBuilderDsl;
import com.commercetools.sync.customobjects.CustomObjectSyncOptions;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.services.CustomObjectService;
import com.commercetools.sync.services.impl.BaseService;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CustomObjectServiceImpl
extends BaseService<CustomObjectSyncOptions, CustomObject, CustomObjectDraft, ByProjectKeyCustomObjectsGet, CustomObjectPagedQueryResponse, ByProjectKeyCustomObjectsByContainerByKeyGet, CustomObject, CustomObjectQueryBuilderDsl, ByProjectKeyCustomObjectsPost>
implements CustomObjectService {
    public CustomObjectServiceImpl(@Nonnull CustomObjectSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        return this.fetchMatchingCustomObjects(identifiers).thenApply(chunk -> {
            chunk.forEach(resource -> this.keyToIdCache.put((Object)this.keyMapper((CustomObject)resource), (Object)resource.getId()));
            return this.keyToIdCache.asMap();
        });
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCustomObjectId(@Nonnull CustomObjectCompositeIdentifier identifier) {
        return super.fetchCachedResourceId(identifier.toString(), this::keyMapper, this.queryOneIdentifier(identifier));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<CustomObject>> fetchMatchingCustomObjects(@Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        return super.fetchMatchingResources(this.getKeys(identifiers), this::keyMapper, this::createQuery);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CustomObject>> fetchCustomObject(@Nonnull CustomObjectCompositeIdentifier identifier) {
        ByProjectKeyCustomObjectsByContainerByKeyGet query = ((CustomObjectSyncOptions)this.syncOptions).getCtpClient().customObjects().withContainerAndKey(identifier.getContainer(), identifier.getKey()).get();
        return super.fetchResource(identifier.toString(), query);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CustomObject>> upsertCustomObject(@Nonnull CustomObjectDraft customObjectDraft) {
        return super.createResource(customObjectDraft, this::keyMapper, CustomObject::getId, customObject -> customObject, () -> ((CustomObjectSyncOptions)this.syncOptions).getCtpClient().customObjects().post(customObjectDraft));
    }

    @Override
    @Nonnull
    CompletionStage<Optional<CustomObject>> executeCreateCommand(@Nonnull CustomObjectDraft draft, @Nonnull String key, @Nonnull Function<CustomObject, String> idMapper, @Nonnull Function<CustomObject, CustomObject> resourceMapper, @Nonnull ByProjectKeyCustomObjectsPost createCommand) {
        return createCommand.execute().thenApply(resource -> {
            if (resource != null) {
                CustomObject customObject = (CustomObject)resource.getBody();
                this.keyToIdCache.put((Object)key, (Object)((String)idMapper.apply(customObject)));
                return Optional.of((CustomObject)resourceMapper.apply(customObject));
            }
            return Optional.empty();
        });
    }

    @Nonnull
    private ByProjectKeyCustomObjectsGet createQuery(@Nonnull Set<String> keys) {
        Set identifiers = keys.stream().map(CustomObjectCompositeIdentifier::of).collect(Collectors.toSet());
        String whereQuery = identifiers.stream().map(identifier -> "(container=\"" + identifier.getContainer() + "\" AND key=\"" + identifier.getKey() + "\")").collect(Collectors.joining(" OR "));
        return ((CustomObjectSyncOptions)this.syncOptions).getCtpClient().customObjects().get().withWhere((Object)whereQuery);
    }

    @Nonnull
    private Set<String> getKeys(@Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        return identifiers.stream().map(CustomObjectCompositeIdentifier::toString).collect(Collectors.toSet());
    }

    @Nonnull
    private String keyMapper(@Nonnull CustomObjectDraft customObjectDraft) {
        return CustomObjectCompositeIdentifier.of(customObjectDraft).toString();
    }

    @Nonnull
    private String keyMapper(@Nonnull CustomObject customObject) {
        return CustomObjectCompositeIdentifier.of(customObject).toString();
    }

    @Nonnull
    private ByProjectKeyCustomObjectsGet queryOneIdentifier(@Nonnull CustomObjectCompositeIdentifier identifier) {
        return ((CustomObjectSyncOptions)this.syncOptions).getCtpClient().customObjects().get().withWhere((Object)"container=:container AND key=:key").withPredicateVar("container", (Object)identifier.getContainer()).withPredicateVar("key", (Object)identifier.getKey());
    }
}

