/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyCustomersGet;
import com.commercetools.api.client.ByProjectKeyCustomersKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyCustomersPost;
import com.commercetools.api.models.customer.Customer;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.api.models.customer.CustomerPagedQueryResponse;
import com.commercetools.api.models.customer.CustomerSignInResult;
import com.commercetools.api.models.customer.CustomerUpdateAction;
import com.commercetools.api.models.customer.CustomerUpdateBuilder;
import com.commercetools.api.predicates.query.customer.CustomerQueryBuilderDsl;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.impl.BaseService;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomerServiceImpl
extends BaseService<CustomerSyncOptions, Customer, CustomerDraft, ByProjectKeyCustomersGet, CustomerPagedQueryResponse, ByProjectKeyCustomersKeyByKeyGet, CustomerSignInResult, CustomerQueryBuilderDsl, ByProjectKeyCustomersPost>
implements CustomerService {
    public CustomerServiceImpl(@Nonnull CustomerSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> customerKeys) {
        return super.cacheKeysToIdsUsingGraphQl(customerKeys, GraphQlQueryResource.CUSTOMERS);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Customer>> fetchMatchingCustomersByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, customer -> customer.getKey(), keysNotCached -> ((CustomerSyncOptions)this.syncOptions).getCtpClient().customers().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Customer>> fetchCustomerByKey(@Nullable String key) {
        return super.fetchResource(key, ((CustomerSyncOptions)this.syncOptions).getCtpClient().customers().withKey(key).get());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCustomerId(@Nonnull String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        String id = (String)this.keyToIdCache.getIfPresent((Object)key);
        if (id != null) {
            return CompletableFuture.completedFuture(Optional.of(id));
        }
        return this.fetchCustomerByKey(key).thenApply(customer -> customer.map(Customer::getId));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Customer>> createCustomer(@Nonnull CustomerDraft customerDraft) {
        return super.createResource(customerDraft, CustomerDraft::getKey, customerSignInResult -> customerSignInResult.getCustomer().getId(), CustomerSignInResult::getCustomer, () -> ((CustomerSyncOptions)this.syncOptions).getCtpClient().customers().post(customerDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<Customer> updateCustomer(@Nonnull Customer customer, @Nonnull List<CustomerUpdateAction> updateActions) {
        List<List<CustomerUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)customer));
        for (List<CustomerUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedCustomer -> ((CustomerSyncOptions)this.syncOptions).getCtpClient().customers().withId(updatedCustomer.getId()).post(CustomerUpdateBuilder.of().actions(batch).version(updatedCustomer.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }
}

