/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyInventoryByIDGet;
import com.commercetools.api.client.ByProjectKeyInventoryGet;
import com.commercetools.api.client.ByProjectKeyInventoryPost;
import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.api.models.inventory.InventoryEntryUpdateAction;
import com.commercetools.api.models.inventory.InventoryEntryUpdateBuilder;
import com.commercetools.api.models.inventory.InventoryPagedQueryResponse;
import com.commercetools.api.predicates.query.inventory.InventoryEntryQueryBuilderDsl;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventoryEntryIdentifier;
import com.commercetools.sync.inventories.helpers.InventoryEntryQueryBuilder;
import com.commercetools.sync.services.InventoryService;
import com.commercetools.sync.services.impl.BaseService;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class InventoryServiceImpl
extends BaseService<InventorySyncOptions, InventoryEntry, InventoryEntryDraft, ByProjectKeyInventoryGet, InventoryPagedQueryResponse, ByProjectKeyInventoryByIDGet, InventoryEntry, InventoryEntryQueryBuilderDsl, ByProjectKeyInventoryPost>
implements InventoryService {
    public InventoryServiceImpl(@Nonnull InventorySyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<InventoryEntry>> fetchInventoryEntriesByIdentifiers(@Nonnull Set<InventoryEntryIdentifier> identifiers) {
        ProjectApiRoot ctpClient = ((InventorySyncOptions)this.syncOptions).getCtpClient();
        return ((CompletableFuture)ChunkUtils.executeChunks(InventoryEntryQueryBuilder.buildQueries(ctpClient, identifiers)).thenApply(apiHttpResponses -> apiHttpResponses.stream().map(apiHttpResponse -> ((InventoryPagedQueryResponse)apiHttpResponse.getBody()).getResults()).flatMap(Collection::stream).collect(Collectors.toList()))).thenApply(this::cacheAndMapToSet);
    }

    private HashSet<InventoryEntry> cacheAndMapToSet(@Nonnull List<InventoryEntry> results) {
        results.forEach(resource -> this.keyToIdCache.put((Object)String.valueOf(InventoryEntryIdentifier.of(resource)), (Object)resource.getId()));
        return new HashSet<InventoryEntry>(results);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<InventoryEntry>> createInventoryEntry(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        return super.createResource(inventoryEntryDraft, draft -> InventoryEntryIdentifier.of(draft).toString(), entry -> entry.getId(), inventoryEntry -> inventoryEntry, () -> ((InventorySyncOptions)this.syncOptions).getCtpClient().inventory().post(inventoryEntryDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<InventoryEntry> updateInventoryEntry(@Nonnull InventoryEntry inventoryEntry, @Nonnull List<InventoryEntryUpdateAction> updateActions) {
        List<List<InventoryEntryUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)inventoryEntry));
        for (List<InventoryEntryUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedInventory -> ((InventorySyncOptions)this.syncOptions).getCtpClient().inventory().withId(updatedInventory.getId()).post(InventoryEntryUpdateBuilder.of().actions(batch).version(updatedInventory.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }
}

