/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyStatesGet;
import com.commercetools.api.client.ByProjectKeyStatesKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyStatesPost;
import com.commercetools.api.models.state.State;
import com.commercetools.api.models.state.StateDraft;
import com.commercetools.api.models.state.StatePagedQueryResponse;
import com.commercetools.api.models.state.StateUpdateAction;
import com.commercetools.api.models.state.StateUpdateBuilder;
import com.commercetools.api.predicates.query.state.StateQueryBuilderDsl;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import com.commercetools.sync.states.StateSyncOptions;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StateServiceImpl
extends BaseServiceWithKey<StateSyncOptions, State, StateDraft, ByProjectKeyStatesGet, StatePagedQueryResponse, ByProjectKeyStatesKeyByKeyGet, State, StateQueryBuilderDsl, ByProjectKeyStatesPost>
implements StateService {
    private static final String STATE_KEY_NOT_SET = "State with id: '%s' has no key set. Keys are required for state matching.";

    public StateServiceImpl(@Nonnull StateSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> categoryKeys) {
        return super.cacheKeysToIdsUsingGraphQl(categoryKeys, GraphQlQueryResource.STATES);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedStateId(@Nullable String key) {
        if (key == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        ByProjectKeyStatesGet query = ((StateSyncOptions)this.syncOptions).getCtpClient().states().get().withWhere((Object)"key in :keys").withPredicateVar("keys", Collections.singletonList(key));
        return super.fetchCachedResourceId(key, query);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<State>> fetchMatchingStatesByKeys(@Nonnull Set<String> stateKeys) {
        return this.fetchMatchingStates(stateKeys, false);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<State>> fetchMatchingStatesByKeysWithTransitions(@Nonnull Set<String> stateKeys) {
        return this.fetchMatchingStates(stateKeys, true);
    }

    private CompletionStage<Set<State>> fetchMatchingStates(@Nonnull Set<String> stateKeys, boolean withTransitions) {
        return super.fetchMatchingResources(stateKeys, State::getKey, keysNotCached -> {
            ByProjectKeyStatesGet query = ((StateSyncOptions)this.syncOptions).getCtpClient().states().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached);
            if (withTransitions) {
                query = query.withExpand((Object)"transitions[*]");
            }
            return query;
        });
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<State>> fetchState(@Nullable String key) {
        return super.fetchResource(key, ((StateSyncOptions)this.syncOptions).getCtpClient().states().withKey(key).get());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<State>> createState(@Nonnull StateDraft stateDraft) {
        return super.createResource(stateDraft, StateDraft::getKey, State::getId, Function.identity(), () -> ((StateSyncOptions)this.syncOptions).getCtpClient().states().post(stateDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<State> updateState(@Nonnull State state, @Nonnull List<StateUpdateAction> updateActions) {
        List<List<StateUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)state));
        for (List<StateUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedState -> ((StateSyncOptions)this.syncOptions).getCtpClient().states().withId(updatedState.getId()).post(StateUpdateBuilder.of().actions(batch).version(updatedState.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }
}

