/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.helpers;

import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.customer.CustomerResourceIdentifier;
import com.commercetools.api.models.customer.CustomerResourceIdentifierBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListDraft;
import com.commercetools.api.models.shopping_list.ShoppingListDraftBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListLineItemDraft;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.helpers.LineItemReferenceResolver;
import com.commercetools.sync.shoppinglists.helpers.ShoppingListBatchValidator;
import com.commercetools.sync.shoppinglists.helpers.TextLineItemReferenceResolver;
import io.vrap.rmf.base.client.utils.CompletableFutureUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ShoppingListReferenceResolver
extends CustomReferenceResolver<ShoppingListDraft, ShoppingListDraftBuilder, ShoppingListSyncOptions> {
    static final String FAILED_TO_RESOLVE_CUSTOMER_REFERENCE = "Failed to resolve customer resource identifier on ShoppingListDraft with key:'%s'. Reason: %s";
    static final String CUSTOMER_DOES_NOT_EXIST = "Customer with key '%s' doesn't exist.";
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on ShoppingListDraft with key:'%s'. ";
    private final CustomerService customerService;
    private final TypeService typeService;
    private final LineItemReferenceResolver lineItemReferenceResolver;
    private final TextLineItemReferenceResolver textLineItemReferenceResolver;

    public ShoppingListReferenceResolver(@Nonnull ShoppingListSyncOptions shoppingListSyncOptions, @Nonnull CustomerService customerService, @Nonnull TypeService typeService) {
        super(shoppingListSyncOptions, typeService);
        this.lineItemReferenceResolver = new LineItemReferenceResolver(shoppingListSyncOptions, typeService);
        this.textLineItemReferenceResolver = new TextLineItemReferenceResolver(shoppingListSyncOptions, typeService);
        this.customerService = customerService;
        this.typeService = typeService;
    }

    @Override
    @Nonnull
    public CompletionStage<ShoppingListDraft> resolveReferences(@Nonnull ShoppingListDraft shoppingListDraft) {
        return this.resolveCustomerReference(ShoppingListDraftBuilder.of((ShoppingListDraft)shoppingListDraft)).thenCompose(this::resolveCustomTypeReference).thenCompose(this::resolveLineItemReferences).thenCompose(this::resolveTextLineItemReferences).thenApply(ShoppingListDraftBuilder::build);
    }

    @Nonnull
    protected CompletionStage<ShoppingListDraftBuilder> resolveCustomerReference(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        CustomerResourceIdentifier customerResourceIdentifier = draftBuilder.getCustomer();
        if (customerResourceIdentifier != null && customerResourceIdentifier.getId() == null) {
            String customerKey;
            try {
                customerKey = ShoppingListReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)customerResourceIdentifier);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_REFERENCE, draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveCustomerReference(draftBuilder, customerKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ShoppingListDraftBuilder> fetchAndResolveCustomerReference(@Nonnull ShoppingListDraftBuilder draftBuilder, @Nonnull String customerKey) {
        return this.customerService.fetchCachedCustomerId(customerKey).thenCompose(resolvedCustomerIdOptional -> resolvedCustomerIdOptional.map(resolvedCustomerId -> CompletableFuture.completedFuture(draftBuilder.customer(CustomerResourceIdentifierBuilder.of().id(resolvedCustomerId).build()))).orElseGet(() -> {
            String errorMessage = String.format(CUSTOMER_DOES_NOT_EXIST, customerKey);
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_REFERENCE, draftBuilder.getKey(), errorMessage)));
        }));
    }

    @Override
    @Nonnull
    protected CompletionStage<ShoppingListDraftBuilder> resolveCustomTypeReference(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, ShoppingListDraftBuilder::getCustom, ShoppingListDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }

    @Nonnull
    private CompletionStage<ShoppingListDraftBuilder> resolveLineItemReferences(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        if (draftBuilder.getLineItems() != null) {
            return com.commercetools.sync.commons.utils.CompletableFutureUtils.mapValuesToFutureOfCompletedValues(draftBuilder.getLineItems(), shoppingListLineItemDraft -> this.lineItemReferenceResolver.resolveReferences((ShoppingListLineItemDraft)shoppingListLineItemDraft), Collectors.toList()).thenApply(arg_0 -> ((ShoppingListDraftBuilder)draftBuilder).lineItems(arg_0));
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ShoppingListDraftBuilder> resolveTextLineItemReferences(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        if (draftBuilder.getTextLineItems() != null) {
            return com.commercetools.sync.commons.utils.CompletableFutureUtils.mapValuesToFutureOfCompletedValues(draftBuilder.getTextLineItems(), this.textLineItemReferenceResolver::resolveReferences, Collectors.toList()).thenApply(arg_0 -> ((ShoppingListDraftBuilder)draftBuilder).textLineItems(arg_0));
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    public CompletableFuture<List<Map<String, String>>> populateKeyToIdCachesForReferencedKeys(@Nonnull ShoppingListBatchValidator.ReferencedKeys referencedKeys) {
        Set<String> customerKeys;
        ArrayList<CompletionStage<Map<String, String>>> futures = new ArrayList<CompletionStage<Map<String, String>>>();
        Set<String> typeKeys = referencedKeys.getTypeKeys();
        if (!typeKeys.isEmpty()) {
            futures.add(this.typeService.cacheKeysToIds(typeKeys));
        }
        if (!(customerKeys = referencedKeys.getCustomerKeys()).isEmpty()) {
            futures.add(this.customerService.cacheKeysToIds(customerKeys));
        }
        return com.commercetools.sync.commons.utils.CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList());
    }
}

