/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.utils;

import com.commercetools.api.models.state.State;
import com.commercetools.api.models.state.StateAddRolesActionBuilder;
import com.commercetools.api.models.state.StateChangeInitialActionBuilder;
import com.commercetools.api.models.state.StateChangeTypeActionBuilder;
import com.commercetools.api.models.state.StateDraft;
import com.commercetools.api.models.state.StateReference;
import com.commercetools.api.models.state.StateRemoveRolesActionBuilder;
import com.commercetools.api.models.state.StateResourceIdentifier;
import com.commercetools.api.models.state.StateResourceIdentifierBuilder;
import com.commercetools.api.models.state.StateRoleEnum;
import com.commercetools.api.models.state.StateSetDescriptionActionBuilder;
import com.commercetools.api.models.state.StateSetNameActionBuilder;
import com.commercetools.api.models.state.StateSetTransitionsActionBuilder;
import com.commercetools.api.models.state.StateUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;

public final class StateUpdateActionUtils {
    private StateUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<StateUpdateAction> buildChangeTypeAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldState.getType(), newState.getType(), () -> StateChangeTypeActionBuilder.of().type(newState.getType()).build());
    }

    @Nonnull
    public static Optional<StateUpdateAction> buildSetNameAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldState.getName(), newState.getName(), () -> StateSetNameActionBuilder.of().name(newState.getName()).build());
    }

    @Nonnull
    public static Optional<StateUpdateAction> buildSetDescriptionAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldState.getDescription(), newState.getDescription(), () -> StateSetDescriptionActionBuilder.of().description(newState.getDescription()).build());
    }

    @Nonnull
    public static Optional<StateUpdateAction> buildChangeInitialAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        boolean isNewStateInitial = BooleanUtils.toBoolean((Boolean)newState.getInitial());
        boolean isOldStateInitial = BooleanUtils.toBoolean((Boolean)oldState.getInitial());
        return CommonTypeUpdateActionUtils.buildUpdateAction(isOldStateInitial, isNewStateInitial, () -> StateChangeInitialActionBuilder.of().initial(Boolean.valueOf(isNewStateInitial)).build());
    }

    @Nonnull
    public static List<StateUpdateAction> buildRolesUpdateActions(@Nonnull State oldState, @Nonnull StateDraft newState) {
        List<StateRoleEnum> add;
        boolean emptyOld;
        boolean emptyNew = newState.getRoles() == null || newState.getRoles().isEmpty();
        boolean bl = emptyOld = oldState.getRoles() == null || oldState.getRoles().isEmpty();
        if (emptyNew && emptyOld) {
            return List.of();
        }
        ArrayList<StateRoleEnum> newRoles = emptyNew ? new ArrayList() : newState.getRoles();
        ArrayList<StateRoleEnum> oldRoles = emptyOld ? new ArrayList() : oldState.getRoles();
        ArrayList<StateUpdateAction> actions = new ArrayList<StateUpdateAction>();
        List<StateRoleEnum> remove = StateUpdateActionUtils.diffRoles(oldRoles, newRoles);
        if (!remove.isEmpty()) {
            actions.add((StateUpdateAction)StateRemoveRolesActionBuilder.of().roles(remove).build());
        }
        if (!(add = StateUpdateActionUtils.diffRoles(newRoles, oldRoles)).isEmpty()) {
            actions.add((StateUpdateAction)StateAddRolesActionBuilder.of().roles(add).build());
        }
        return actions;
    }

    @Nonnull
    public static Optional<StateUpdateAction> buildSetTransitionsAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        Set<StateReference> oldTransitions;
        boolean emptyOld;
        boolean emptyNew = newState.getTransitions() == null || newState.getTransitions().isEmpty() || newState.getTransitions().stream().noneMatch(Objects::nonNull);
        boolean bl = emptyOld = oldState.getTransitions() == null || oldState.getTransitions().isEmpty() || oldState.getTransitions().stream().noneMatch(Objects::nonNull);
        if (emptyNew && emptyOld) {
            return Optional.empty();
        }
        if (newState.getTransitions() == null) {
            return Optional.of(StateSetTransitionsActionBuilder.of().transitions((List)null).build());
        }
        if (emptyNew) {
            return Optional.of(StateSetTransitionsActionBuilder.of().transitions(List.of()).build());
        }
        Set<StateResourceIdentifier> newTransitions = newState.getTransitions().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (StateUpdateActionUtils.hasDifferentTransitions(newTransitions, oldTransitions = oldState.getTransitions().stream().filter(Objects::nonNull).collect(Collectors.toSet()))) {
            List transitions = newTransitions.stream().map(transition -> StateResourceIdentifierBuilder.of().id(transition.getId()).key(transition.getKey()).build()).collect(Collectors.toList());
            return Optional.of(StateSetTransitionsActionBuilder.of().transitions(transitions).build());
        }
        return Optional.empty();
    }

    private static boolean hasDifferentTransitions(Set<StateResourceIdentifier> newTransitions, Set<StateReference> oldTransitions) {
        List oldTransitionIds;
        List newTransitionIds = newTransitions.stream().map(StateResourceIdentifier::getId).collect(Collectors.toList());
        return !Objects.equals(newTransitionIds, oldTransitionIds = oldTransitions.stream().map(StateReference::getId).collect(Collectors.toList()));
    }

    private static List<StateRoleEnum> diffRoles(List<StateRoleEnum> src, List<StateRoleEnum> dst) {
        return src.stream().map(role -> {
            if (!dst.contains(role)) {
                return role;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

