/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.helpers;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.utils.CategoryAssetUpdateActionUtils;
import com.commercetools.sync.commons.helpers.AssetActionFactory;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.commands.updateactions.AddAsset;
import io.sphere.sdk.categories.commands.updateactions.ChangeAssetOrder;
import io.sphere.sdk.categories.commands.updateactions.RemoveAsset;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.Resource;
import java.util.List;
import javax.annotation.Nonnull;

public final class CategoryAssetActionFactory
extends AssetActionFactory<Category, CategoryDraft> {
    public CategoryAssetActionFactory(@Nonnull CategorySyncOptions syncOptions) {
        this.syncOptions = syncOptions;
    }

    @Override
    public List<UpdateAction<Category>> buildAssetActions(@Nonnull Category oldResource, @Nonnull CategoryDraft newResource, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAssetDraft) {
        return CategoryAssetUpdateActionUtils.buildActions((Resource)oldResource, newResource, oldAsset, newAssetDraft, (CategorySyncOptions)this.syncOptions);
    }

    @Override
    public UpdateAction<Category> buildRemoveAssetAction(@Nonnull String assetKey) {
        return RemoveAsset.ofKey((String)assetKey);
    }

    @Override
    public UpdateAction<Category> buildChangeAssetOrderAction(@Nonnull List<String> newAssetOrder) {
        return ChangeAssetOrder.of(newAssetOrder);
    }

    @Override
    public UpdateAction<Category> buildAddAssetAction(@Nonnull AssetDraft assetDraft, @Nonnull Integer position) {
        return AddAsset.of((AssetDraft)assetDraft, (Integer)position);
    }
}

