/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.helpers.GenericCustomActionBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.types.Custom;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

final class GenericUpdateActionUtils {
    @Nonnull
    static <T extends Custom, U extends Resource<U>> Optional<UpdateAction<U>> buildTypedSetCustomTypeUpdateAction(@Nullable String customTypeId, @Nullable Map<String, JsonNode> customFieldsJsonMap, @Nonnull T resource, @Nonnull GenericCustomActionBuilder<U> customActionBuilder, @Nullable Integer variantId, @Nonnull Function<T, String> resourceIdGetter, @Nonnull Function<T, String> resourceTypeIdGetter, @Nonnull Function<T, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) {
        if (!StringUtils.isBlank((CharSequence)customTypeId)) {
            return Optional.of(customActionBuilder.buildSetCustomTypeAction(variantId, updateIdGetter.apply(resource), customTypeId, customFieldsJsonMap));
        }
        String errorMessage = String.format("Failed to build 'setCustomType' update action on the %s with id '%s'. Reason: New Custom Type id is blank (null/empty).", resourceTypeIdGetter.apply(resource), resourceIdGetter.apply(resource));
        syncOptions.applyErrorCallback(errorMessage);
        return Optional.empty();
    }

    private GenericUpdateActionUtils() {
    }
}

