/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.helpers;

import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InventoryEntryIdentifier {
    private String inventoryEntrySku;
    private String inventoryEntryChannelKey;

    private InventoryEntryIdentifier(@Nonnull String inventoryEntrySku, @Nullable String inventoryEntryChannelKey) {
        this.inventoryEntrySku = inventoryEntrySku;
        this.inventoryEntryChannelKey = inventoryEntryChannelKey;
    }

    public static InventoryEntryIdentifier of(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        ResourceIdentifier supplyChannelIdentifier = inventoryEntryDraft.getSupplyChannel();
        return new InventoryEntryIdentifier(inventoryEntryDraft.getSku(), supplyChannelIdentifier != null ? supplyChannelIdentifier.getId() : null);
    }

    public static InventoryEntryIdentifier of(@Nonnull InventoryEntry inventoryEntry) {
        Reference supplyChannel = inventoryEntry.getSupplyChannel();
        return new InventoryEntryIdentifier(inventoryEntry.getSku(), supplyChannel != null ? supplyChannel.getId() : null);
    }

    public static InventoryEntryIdentifier of(@Nonnull String inventoryEntrySku, @Nullable String inventoryEntryChannelKey) {
        return new InventoryEntryIdentifier(inventoryEntrySku, inventoryEntryChannelKey);
    }

    public String getInventoryEntrySku() {
        return this.inventoryEntrySku;
    }

    public String getInventoryEntryChannelKey() {
        return this.inventoryEntryChannelKey;
    }

    public String toString() {
        return String.format("{sku='%s', channelKey='%s'}", this.inventoryEntrySku, this.inventoryEntryChannelKey);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InventoryEntryIdentifier)) {
            return false;
        }
        InventoryEntryIdentifier that = (InventoryEntryIdentifier)other;
        return this.getInventoryEntrySku().equals(that.getInventoryEntrySku()) && Objects.equals(this.getInventoryEntryChannelKey(), that.getInventoryEntryChannelKey());
    }

    public int hashCode() {
        return Objects.hash(this.getInventoryEntrySku(), this.getInventoryEntryChannelKey());
    }
}

