/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products;

import com.commercetools.sync.commons.BaseSyncOptionsBuilder;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.SyncFilter;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import javax.annotation.Nonnull;

public final class ProductSyncOptionsBuilder
extends BaseSyncOptionsBuilder<ProductSyncOptionsBuilder, ProductSyncOptions, Product, ProductDraft> {
    public static final int BATCH_SIZE_DEFAULT = 30;
    private SyncFilter syncFilter;
    static final boolean ENSURE_CHANNELS_DEFAULT = false;
    private boolean ensurePriceChannels = false;

    private ProductSyncOptionsBuilder(SphereClient ctpClient) {
        this.ctpClient = ctpClient;
    }

    public static ProductSyncOptionsBuilder of(@Nonnull SphereClient ctpClient) {
        return (ProductSyncOptionsBuilder)new ProductSyncOptionsBuilder(ctpClient).batchSize(30);
    }

    @Nonnull
    public ProductSyncOptionsBuilder syncFilter(@Nonnull SyncFilter syncFilter) {
        this.syncFilter = syncFilter;
        return this;
    }

    @Nonnull
    public ProductSyncOptionsBuilder ensurePriceChannels(boolean ensurePriceChannels) {
        this.ensurePriceChannels = ensurePriceChannels;
        return this;
    }

    @Override
    @Nonnull
    public ProductSyncOptions build() {
        return new ProductSyncOptions(this.ctpClient, this.errorCallback, this.warningCallback, this.batchSize, this.syncFilter, this.beforeUpdateCallback, this.beforeCreateCallback, this.ensurePriceChannels);
    }

    @Override
    protected ProductSyncOptionsBuilder getThis() {
        return this;
    }
}

