/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.channels.Channel;
import io.sphere.sdk.customergroups.CustomerGroup;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.PriceDraft;
import io.sphere.sdk.products.PriceDraftBuilder;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class PriceReferenceResolver
extends CustomReferenceResolver<PriceDraft, PriceDraftBuilder, ProductSyncOptions> {
    private final ChannelService channelService;
    private final CustomerGroupService customerGroupService;
    static final String CHANNEL_DOES_NOT_EXIST = "Channel with key '%s' does not exist.";
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on PriceDraft with country:'%s' and value: '%s'.";
    static final String FAILED_TO_RESOLVE_REFERENCE = "Failed to resolve '%s' reference on PriceDraft with country:'%s' and value: '%s'. Reason: %s";
    static final String CUSTOMER_GROUP_DOES_NOT_EXIST = "Customer Group with key '%s' does not exist.";

    public PriceReferenceResolver(@Nonnull ProductSyncOptions options, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService) {
        super(options, typeService);
        this.channelService = channelService;
        this.customerGroupService = customerGroupService;
    }

    @Override
    public CompletionStage<PriceDraft> resolveReferences(@Nonnull PriceDraft priceDraft) {
        return this.resolveCustomTypeReference(PriceDraftBuilder.of((PriceDraft)priceDraft)).thenCompose(this::resolveChannelReference).thenCompose(this::resolveCustomerGroupReference).thenApply(PriceDraftBuilder::build);
    }

    @Override
    @Nonnull
    protected CompletionStage<PriceDraftBuilder> resolveCustomTypeReference(@Nonnull PriceDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, PriceDraftBuilder::getCustom, PriceDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getCountry(), draftBuilder.getValue()));
    }

    @Nonnull
    CompletionStage<PriceDraftBuilder> resolveChannelReference(@Nonnull PriceDraftBuilder draftBuilder) {
        ResourceIdentifier channelResourceIdentifier = draftBuilder.getChannel();
        if (channelResourceIdentifier != null && channelResourceIdentifier.getId() == null) {
            String channelKey;
            try {
                channelKey = PriceReferenceResolver.getKeyFromResourceIdentifier(channelResourceIdentifier);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, Channel.resourceTypeId(), draftBuilder.getCountry(), draftBuilder.getValue(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveChannelReference(draftBuilder, channelKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<PriceDraftBuilder> fetchAndResolveChannelReference(@Nonnull PriceDraftBuilder draftBuilder, @Nonnull String channelKey) {
        return this.channelService.fetchCachedChannelId(channelKey).thenCompose(resolvedChannelIdOptional -> resolvedChannelIdOptional.map(resolvedChannelId -> CompletableFuture.completedFuture(draftBuilder.channel(Channel.referenceOfId((String)resolvedChannelId).toResourceIdentifier()))).orElseGet(() -> {
            CompletableFuture result = new CompletableFuture();
            this.createChannelAndSetReference(channelKey, draftBuilder).whenComplete((draftWithCreatedChannel, exception) -> {
                if (exception != null) {
                    result.completeExceptionally(new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, Channel.resourceTypeId(), draftBuilder.getCountry(), draftBuilder.getValue(), exception.getMessage()), (Throwable)exception));
                } else {
                    result.complete(draftWithCreatedChannel);
                }
            });
            return result;
        }));
    }

    @Nonnull
    private CompletionStage<PriceDraftBuilder> createChannelAndSetReference(@Nonnull String channelKey, @Nonnull PriceDraftBuilder draftBuilder) {
        if (((ProductSyncOptions)this.options).shouldEnsurePriceChannels()) {
            return this.channelService.createAndCacheChannel(channelKey).thenCompose(createdChannelOptional -> {
                if (createdChannelOptional.isPresent()) {
                    return CompletableFuture.completedFuture(draftBuilder.channel((Referenceable)createdChannelOptional.get()));
                }
                ReferenceResolutionException referenceResolutionException = new ReferenceResolutionException(String.format(CHANNEL_DOES_NOT_EXIST, channelKey));
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
            });
        }
        ReferenceResolutionException referenceResolutionException = new ReferenceResolutionException(String.format(CHANNEL_DOES_NOT_EXIST, channelKey));
        return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
    }

    @Nonnull
    CompletionStage<PriceDraftBuilder> resolveCustomerGroupReference(@Nonnull PriceDraftBuilder draftBuilder) {
        Reference customerGroupReference = draftBuilder.getCustomerGroup();
        if (customerGroupReference != null) {
            String customerGroupKey;
            try {
                customerGroupKey = PriceReferenceResolver.getIdFromReference(customerGroupReference);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, CustomerGroup.referenceTypeId(), draftBuilder.getCountry(), draftBuilder.getValue(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveCustomerGroupReference(draftBuilder, customerGroupKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<PriceDraftBuilder> fetchAndResolveCustomerGroupReference(@Nonnull PriceDraftBuilder draftBuilder, @Nonnull String customerGroupKey) {
        return this.customerGroupService.fetchCachedCustomerGroupId(customerGroupKey).thenCompose(resolvedCustomerGroupIdOptional -> resolvedCustomerGroupIdOptional.map(resolvedCustomerGroupId -> CompletableFuture.completedFuture(draftBuilder.customerGroup((Referenceable)CustomerGroup.referenceOfId((String)resolvedCustomerGroupId)))).orElseGet(() -> {
            String errorMessage = String.format(CUSTOMER_GROUP_DOES_NOT_EXIST, customerGroupKey);
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, CustomerGroup.referenceTypeId(), draftBuilder.getCountry(), draftBuilder.getValue(), errorMessage)));
        }));
    }
}

