/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.producttypes.utils.LocalizedEnumValueUpdateActionUtils;
import com.commercetools.sync.producttypes.utils.PlainEnumValueUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.TextInputHint;
import io.sphere.sdk.products.attributes.AttributeConstraint;
import io.sphere.sdk.products.attributes.AttributeDefinition;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.EnumAttributeType;
import io.sphere.sdk.products.attributes.LocalizedEnumAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeAttributeConstraint;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeAttributeDefinitionLabel;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeInputHint;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeIsSearchable;
import io.sphere.sdk.producttypes.commands.updateactions.SetInputTip;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

final class AttributeDefinitionUpdateActionUtils {
    @Nonnull
    static List<UpdateAction<ProductType>> buildActions(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinitionDraft) {
        List<UpdateAction<ProductType>> updateActions = OptionalUtils.filterEmptyOptionals(AttributeDefinitionUpdateActionUtils.buildChangeLabelUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildSetInputTipUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildChangeIsSearchableUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildChangeInputHintUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildChangeAttributeConstraintUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft));
        updateActions.addAll(AttributeDefinitionUpdateActionUtils.buildEnumUpdateActions(oldAttributeDefinition, newAttributeDefinitionDraft));
        return updateActions;
    }

    @Nonnull
    static List<UpdateAction<ProductType>> buildEnumUpdateActions(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinitionDraft) {
        AttributeType oldAttributeType = oldAttributeDefinition.getAttributeType();
        AttributeType newAttributeType = newAttributeDefinitionDraft.getAttributeType();
        return AttributeDefinitionUpdateActionUtils.getEnumAttributeType(oldAttributeType).map(oldEnumAttributeType -> AttributeDefinitionUpdateActionUtils.getEnumAttributeType(newAttributeType).map(newEnumAttributeType -> PlainEnumValueUpdateActionUtils.buildEnumValuesUpdateActions(oldAttributeDefinition.getName(), oldEnumAttributeType.getValues(), newEnumAttributeType.getValues())).orElseGet(Collections::emptyList)).orElseGet(() -> AttributeDefinitionUpdateActionUtils.getLocalizedEnumAttributeType(oldAttributeType).map(oldLocalizedEnumAttributeType -> AttributeDefinitionUpdateActionUtils.getLocalizedEnumAttributeType(newAttributeType).map(newLocalizedEnumAttributeType -> LocalizedEnumValueUpdateActionUtils.buildLocalizedEnumValuesUpdateActions(oldAttributeDefinition.getName(), oldLocalizedEnumAttributeType.getValues(), newLocalizedEnumAttributeType.getValues())).orElseGet(Collections::emptyList)).orElseGet(Collections::emptyList));
    }

    private static Optional<EnumAttributeType> getEnumAttributeType(@Nonnull AttributeType attributeType) {
        SetAttributeType setFieldType;
        AttributeType subType;
        if (attributeType instanceof EnumAttributeType) {
            return Optional.of((EnumAttributeType)attributeType);
        }
        if (attributeType instanceof SetAttributeType && (subType = (setFieldType = (SetAttributeType)attributeType).getElementType()) instanceof EnumAttributeType) {
            return Optional.of((EnumAttributeType)subType);
        }
        return Optional.empty();
    }

    private static Optional<LocalizedEnumAttributeType> getLocalizedEnumAttributeType(@Nonnull AttributeType attributeType) {
        SetAttributeType setFieldType;
        AttributeType subType;
        if (attributeType instanceof LocalizedEnumAttributeType) {
            return Optional.of((LocalizedEnumAttributeType)attributeType);
        }
        if (attributeType instanceof SetAttributeType && (subType = (setFieldType = (SetAttributeType)attributeType).getElementType()) instanceof LocalizedEnumAttributeType) {
            return Optional.of((LocalizedEnumAttributeType)subType);
        }
        return Optional.empty();
    }

    @Nonnull
    static Optional<UpdateAction<ProductType>> buildChangeLabelUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getLabel(), newAttributeDefinition.getLabel(), () -> ChangeAttributeDefinitionLabel.of((String)oldAttributeDefinition.getName(), (LocalizedString)newAttributeDefinition.getLabel()));
    }

    @Nonnull
    static Optional<UpdateAction<ProductType>> buildSetInputTipUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getInputTip(), newAttributeDefinition.getInputTip(), () -> SetInputTip.of((String)oldAttributeDefinition.getName(), (LocalizedString)newAttributeDefinition.getInputTip()));
    }

    @Nonnull
    static Optional<UpdateAction<ProductType>> buildChangeIsSearchableUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        Boolean searchable = Optional.ofNullable(newAttributeDefinition.isSearchable()).orElse(true);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.isSearchable(), searchable, () -> ChangeIsSearchable.of((String)oldAttributeDefinition.getName(), (Boolean)searchable));
    }

    @Nonnull
    static Optional<UpdateAction<ProductType>> buildChangeInputHintUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        TextInputHint inputHint = Optional.ofNullable(newAttributeDefinition.getInputHint()).orElse(TextInputHint.SINGLE_LINE);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getInputHint(), inputHint, () -> ChangeInputHint.of((String)oldAttributeDefinition.getName(), (TextInputHint)inputHint));
    }

    @Nonnull
    static Optional<UpdateAction<ProductType>> buildChangeAttributeConstraintUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        AttributeConstraint attributeConstraint = Optional.ofNullable(newAttributeDefinition.getAttributeConstraint()).orElse(AttributeConstraint.NONE);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getAttributeConstraint(), attributeConstraint, () -> ChangeAttributeConstraint.of((String)oldAttributeDefinition.getName(), (AttributeConstraint)attributeConstraint));
    }

    private AttributeDefinitionUpdateActionUtils() {
    }
}

