/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.sync.commons.exceptions.InvalidAttributeDefinitionException;
import com.commercetools.sync.commons.exceptions.InvalidProductTypeException;
import com.commercetools.sync.commons.exceptions.InvalidReferenceException;
import com.commercetools.sync.commons.exceptions.ReferenceReplacementException;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.products.attributes.AttributeDefinition;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraftBuilder;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.NestedAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import io.sphere.sdk.producttypes.ProductTypeDraftBuilder;
import io.sphere.sdk.producttypes.queries.ProductTypeQuery;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class ProductTypeReferenceResolutionUtils {
    @Nonnull
    public static List<ProductTypeDraft> mapToProductTypeDrafts(@Nonnull List<ProductType> productTypes) {
        HashSet<Throwable> errors = new HashSet<Throwable>();
        List<ProductTypeDraft> referenceReplacedDrafts = productTypes.stream().filter(Objects::nonNull).map(productType -> {
            List<AttributeDefinitionDraft> referenceReplacedAttributeDefinitions;
            try {
                referenceReplacedAttributeDefinitions = ProductTypeReferenceResolutionUtils.replaceAttributeDefinitionsReferenceIdsWithKeys(productType);
            }
            catch (InvalidProductTypeException invalidProductTypeException) {
                errors.add(invalidProductTypeException);
                return null;
            }
            return ProductTypeDraftBuilder.of((ProductType)productType).attributes(referenceReplacedAttributeDefinitions).build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new ReferenceReplacementException("Some errors occurred during reference replacement.", errors);
        }
        return referenceReplacedDrafts;
    }

    @Nonnull
    private static List<AttributeDefinitionDraft> replaceAttributeDefinitionsReferenceIdsWithKeys(@Nonnull ProductType productType) throws InvalidProductTypeException {
        HashSet<Throwable> errors = new HashSet<Throwable>();
        List<AttributeDefinitionDraft> referenceReplacedAttributeDefinitions = productType.getAttributes().stream().map(attributeDefinition -> {
            AttributeType attributeType = attributeDefinition.getAttributeType();
            try {
                AttributeType referenceReplacedType = ProductTypeReferenceResolutionUtils.replaceProductTypeReferenceIdWithKey(attributeType);
                return ((AttributeDefinitionDraftBuilder)AttributeDefinitionDraftBuilder.of((AttributeDefinition)attributeDefinition).attributeType(referenceReplacedType)).build();
            }
            catch (InvalidReferenceException exception) {
                InvalidAttributeDefinitionException attributeDefinitionException = new InvalidAttributeDefinitionException(String.format("Failed to replace some references on the attributeDefinition with name '%s'. Cause: %s", attributeDefinition.getName(), exception.getMessage()), exception);
                errors.add(attributeDefinitionException);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new InvalidProductTypeException(String.format("Failed to replace some references on the productType with key '%s'.", productType.getKey()), errors);
        }
        return referenceReplacedAttributeDefinitions;
    }

    @Nonnull
    private static AttributeType replaceProductTypeReferenceIdWithKey(@Nonnull AttributeType attributeType) throws InvalidReferenceException {
        if (attributeType instanceof NestedAttributeType) {
            Reference<ProductType> referenceReplacedNestedType = ProductTypeReferenceResolutionUtils.replaceProductTypeReferenceIdWithKey((NestedAttributeType)attributeType);
            return NestedAttributeType.of(referenceReplacedNestedType);
        }
        if (attributeType instanceof SetAttributeType) {
            SetAttributeType setAttributeType = (SetAttributeType)attributeType;
            AttributeType elementType = setAttributeType.getElementType();
            AttributeType referenceReplacedElementType = ProductTypeReferenceResolutionUtils.replaceProductTypeReferenceIdWithKey(elementType);
            return SetAttributeType.of((AttributeType)referenceReplacedElementType);
        }
        return attributeType;
    }

    @Nonnull
    private static Reference<ProductType> replaceProductTypeReferenceIdWithKey(@Nonnull NestedAttributeType nestedAttributeType) throws InvalidReferenceException {
        Reference productTypeReference = nestedAttributeType.getTypeReference();
        ProductType productTypeReferenceObj = (ProductType)productTypeReference.getObj();
        if (productTypeReferenceObj != null) {
            return ProductType.referenceOfId((String)productTypeReferenceObj.getKey());
        }
        throw new InvalidReferenceException("ProductType reference is not expanded.");
    }

    @Nonnull
    public static ProductTypeQuery buildProductTypeQuery() {
        return ProductTypeReferenceResolutionUtils.buildProductTypeQuery(0);
    }

    @Nonnull
    public static ProductTypeQuery buildProductTypeQuery(int maximumSetDepth) {
        String nestedTypeReferenceExpansionPath = "attributes[*].type.typeReference";
        ProductTypeQuery productTypeQuery = (ProductTypeQuery)ProductTypeQuery.of().plusExpansionPaths(ExpansionPath.of((String)"attributes[*].type.typeReference"));
        List<ExpansionPath<ProductType>> setsExpansionPath = ProductTypeReferenceResolutionUtils.buildSetOfNestedTypeReferenceExpansionPath(maximumSetDepth);
        return setsExpansionPath.isEmpty() ? productTypeQuery : (ProductTypeQuery)productTypeQuery.plusExpansionPaths(setsExpansionPath);
    }

    @Nonnull
    private static List<ExpansionPath<ProductType>> buildSetOfNestedTypeReferenceExpansionPath(int maximumSetDepth) {
        return IntStream.rangeClosed(1, maximumSetDepth).mapToObj(ProductTypeReferenceResolutionUtils::getExpansionPathForSetDepth).collect(Collectors.toList());
    }

    private static ExpansionPath<ProductType> getExpansionPathForSetDepth(int maximumSetDepth) {
        String elementTypePath = IntStream.range(0, maximumSetDepth).mapToObj(index -> "elementType").collect(Collectors.joining("."));
        return ExpansionPath.of((String)String.format("attributes[*].type.%s.typeReference", elementTypePath));
    }

    private ProductTypeReferenceResolutionUtils() {
    }
}

