/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventoryEntryIdentifier;
import com.commercetools.sync.services.InventoryService;
import com.commercetools.sync.services.impl.BaseService;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.inventory.commands.InventoryEntryCreateCommand;
import io.sphere.sdk.inventory.commands.InventoryEntryUpdateCommand;
import io.sphere.sdk.inventory.expansion.InventoryEntryExpansionModel;
import io.sphere.sdk.inventory.queries.InventoryEntryQuery;
import io.sphere.sdk.inventory.queries.InventoryEntryQueryBuilder;
import io.sphere.sdk.inventory.queries.InventoryEntryQueryModel;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class InventoryServiceImpl
extends BaseService<InventoryEntryDraft, InventoryEntry, InventorySyncOptions, InventoryEntryQuery, InventoryEntryQueryModel, InventoryEntryExpansionModel<InventoryEntry>>
implements InventoryService {
    public InventoryServiceImpl(@Nonnull InventorySyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<InventoryEntry>> fetchInventoryEntriesBySkus(@Nonnull Set<String> skus) {
        return this.fetchMatchingResources(skus, draft -> String.valueOf(InventoryEntryIdentifier.of(draft)), () -> InventoryEntryQueryBuilder.of().plusPredicates(queryModel -> queryModel.sku().isIn((Iterable)skus)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<InventoryEntry>> createInventoryEntry(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        return this.createResource(inventoryEntryDraft, draft -> String.valueOf(InventoryEntryIdentifier.of(draft)), InventoryEntryCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<InventoryEntry> updateInventoryEntry(@Nonnull InventoryEntry inventoryEntry, @Nonnull List<UpdateAction<InventoryEntry>> updateActions) {
        return this.updateResource(inventoryEntry, InventoryEntryUpdateCommand::of, updateActions);
    }
}

