/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import io.sphere.sdk.cartdiscounts.AbsoluteCartDiscountValue;
import io.sphere.sdk.cartdiscounts.CartDiscount;
import io.sphere.sdk.cartdiscounts.CartDiscountDraft;
import io.sphere.sdk.cartdiscounts.CartDiscountTarget;
import io.sphere.sdk.cartdiscounts.CartDiscountValue;
import io.sphere.sdk.cartdiscounts.GiftLineItemCartDiscountValue;
import io.sphere.sdk.cartdiscounts.StackingMode;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeCartPredicate;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeIsActive;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeName;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeRequiresDiscountCode;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeSortOrder;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeStackingMode;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeTarget;
import io.sphere.sdk.cartdiscounts.commands.updateactions.ChangeValue;
import io.sphere.sdk.cartdiscounts.commands.updateactions.SetDescription;
import io.sphere.sdk.cartdiscounts.commands.updateactions.SetValidFrom;
import io.sphere.sdk.cartdiscounts.commands.updateactions.SetValidFromAndUntil;
import io.sphere.sdk.cartdiscounts.commands.updateactions.SetValidUntil;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class CartDiscountUpdateActionUtils {
    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeValueUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        if (oldCartDiscount.getValue() instanceof AbsoluteCartDiscountValue && newCartDiscount.getValue() instanceof AbsoluteCartDiscountValue) {
            AbsoluteCartDiscountValue oldValue = (AbsoluteCartDiscountValue)oldCartDiscount.getValue();
            AbsoluteCartDiscountValue newValue = (AbsoluteCartDiscountValue)newCartDiscount.getValue();
            return CartDiscountUpdateActionUtils.buildChangeAbsoluteValueUpdateAction(oldValue, newValue);
        }
        if (oldCartDiscount.getValue() instanceof GiftLineItemCartDiscountValue && newCartDiscount.getValue() instanceof GiftLineItemCartDiscountValue) {
            GiftLineItemCartDiscountValue oldValue = (GiftLineItemCartDiscountValue)oldCartDiscount.getValue();
            GiftLineItemCartDiscountValue newValue = (GiftLineItemCartDiscountValue)newCartDiscount.getValue();
            return Optional.ofNullable(CartDiscountUpdateActionUtils.buildActionIfDifferentProducts(oldValue, newValue).orElse(CartDiscountUpdateActionUtils.buildActionIfDifferentProductVariantIds(oldValue, newValue).orElse(CartDiscountUpdateActionUtils.buildActionIfDifferentSupplyChannels(oldValue, newValue).orElse(CartDiscountUpdateActionUtils.buildActionIfDifferentDistributionChannels(oldValue, newValue).orElse(null)))));
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getValue(), newCartDiscount.getValue(), () -> ChangeValue.of((CartDiscountValue)newCartDiscount.getValue()));
    }

    @Nonnull
    private static Optional<ChangeValue> buildActionIfDifferentProducts(@Nonnull GiftLineItemCartDiscountValue oldValue, @Nonnull GiftLineItemCartDiscountValue newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldValue.getProduct(), newValue.getProduct(), () -> ChangeValue.of((CartDiscountValue)newValue));
    }

    @Nonnull
    private static Optional<ChangeValue> buildActionIfDifferentProductVariantIds(@Nonnull GiftLineItemCartDiscountValue oldValue, @Nonnull GiftLineItemCartDiscountValue newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldValue.getVariantId(), newValue.getVariantId(), () -> ChangeValue.of((CartDiscountValue)newValue));
    }

    @Nonnull
    private static Optional<ChangeValue> buildActionIfDifferentSupplyChannels(@Nonnull GiftLineItemCartDiscountValue oldValue, @Nonnull GiftLineItemCartDiscountValue newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldValue.getSupplyChannel(), newValue.getSupplyChannel(), () -> ChangeValue.of((CartDiscountValue)newValue));
    }

    @Nonnull
    private static Optional<ChangeValue> buildActionIfDifferentDistributionChannels(@Nonnull GiftLineItemCartDiscountValue oldValue, @Nonnull GiftLineItemCartDiscountValue newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldValue.getDistributionChannel(), newValue.getDistributionChannel(), () -> ChangeValue.of((CartDiscountValue)newValue));
    }

    @Nonnull
    private static Optional<UpdateAction<CartDiscount>> buildChangeAbsoluteValueUpdateAction(@Nonnull AbsoluteCartDiscountValue oldValue, @Nonnull AbsoluteCartDiscountValue newValue) {
        if (newValue.getMoney() == null) {
            return Optional.of(ChangeValue.of((CartDiscountValue)newValue));
        }
        if (oldValue.getMoney().size() != newValue.getMoney().size()) {
            return Optional.of(ChangeValue.of((CartDiscountValue)newValue));
        }
        boolean allOldValuesFoundInNewValues = oldValue.getMoney().stream().allMatch(oldAmount -> newValue.getMoney().stream().filter(newAmount -> newAmount.getCurrency().equals(oldAmount.getCurrency())).anyMatch(newAmount -> newAmount.isEqualTo(oldAmount)));
        return allOldValuesFoundInNewValues ? Optional.empty() : Optional.of(ChangeValue.of((CartDiscountValue)newValue));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeCartPredicateUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getCartPredicate(), newCartDiscount.getCartPredicate(), () -> ChangeCartPredicate.of((String)newCartDiscount.getCartPredicate()));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeTargetUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getTarget(), newCartDiscount.getTarget(), () -> ChangeTarget.of((CartDiscountTarget)newCartDiscount.getTarget()));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeIsActiveUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        Boolean isActive = Optional.ofNullable(newCartDiscount.isActive()).orElse(true);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.isActive(), isActive, () -> ChangeIsActive.of((Boolean)isActive));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeNameUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getName(), newCartDiscount.getName(), () -> ChangeName.of((LocalizedString)newCartDiscount.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildSetDescriptionUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getDescription(), newCartDiscount.getDescription(), () -> SetDescription.of((LocalizedString)newCartDiscount.getDescription()));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeSortOrderUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getSortOrder(), newCartDiscount.getSortOrder(), () -> ChangeSortOrder.of((String)newCartDiscount.getSortOrder()));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeRequiresDiscountCodeUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        Boolean requiresDiscountCode = Optional.ofNullable(newCartDiscount.isRequiresDiscountCode()).orElse(false);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.isRequiringDiscountCode(), requiresDiscountCode, () -> ChangeRequiresDiscountCode.of((Boolean)requiresDiscountCode));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildSetValidFromUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getValidFrom(), newCartDiscount.getValidFrom(), () -> SetValidFrom.of((ZonedDateTime)newCartDiscount.getValidFrom()));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildSetValidUntilUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getValidUntil(), newCartDiscount.getValidUntil(), () -> SetValidUntil.of((ZonedDateTime)newCartDiscount.getValidUntil()));
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildSetValidDatesUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        Optional<UpdateAction<CartDiscount>> setValidFromUpdateAction = CartDiscountUpdateActionUtils.buildSetValidFromUpdateAction(oldCartDiscount, newCartDiscount);
        Optional<UpdateAction<CartDiscount>> setValidUntilUpdateAction = CartDiscountUpdateActionUtils.buildSetValidUntilUpdateAction(oldCartDiscount, newCartDiscount);
        if (setValidFromUpdateAction.isPresent() && setValidUntilUpdateAction.isPresent()) {
            return Optional.of(SetValidFromAndUntil.of((ZonedDateTime)newCartDiscount.getValidFrom(), (ZonedDateTime)newCartDiscount.getValidUntil()));
        }
        return setValidFromUpdateAction.isPresent() ? setValidFromUpdateAction : setValidUntilUpdateAction;
    }

    @Nonnull
    public static Optional<UpdateAction<CartDiscount>> buildChangeStackingModeUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        StackingMode stackingMode = Optional.ofNullable(newCartDiscount.getStackingMode()).orElse(StackingMode.STACKING);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getStackingMode(), stackingMode, () -> ChangeStackingMode.of((StackingMode)stackingMode));
    }

    private CartDiscountUpdateActionUtils() {
    }
}

