/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.QuadConsumer;
import com.commercetools.sync.commons.utils.TriConsumer;
import com.commercetools.sync.commons.utils.TriFunction;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.commands.UpdateAction;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseSyncOptions<U, V> {
    private final SphereClient ctpClient;
    private final QuadConsumer<SyncException, Optional<V>, Optional<U>, List<UpdateAction<U>>> errorCallback;
    private final TriConsumer<SyncException, Optional<V>, Optional<U>> warningCallback;
    private int batchSize;
    private final TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback;
    private final Function<V, V> beforeCreateCallback;

    protected BaseSyncOptions(@Nonnull SphereClient ctpClient, @Nullable QuadConsumer<SyncException, Optional<V>, Optional<U>, List<UpdateAction<U>>> errorCallback, @Nullable TriConsumer<SyncException, Optional<V>, Optional<U>> warningCallback, int batchSize, @Nullable TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback, @Nullable Function<V, V> beforeCreateCallback) {
        this.ctpClient = ctpClient;
        this.errorCallback = errorCallback;
        this.batchSize = batchSize;
        this.warningCallback = warningCallback;
        this.beforeUpdateCallback = beforeUpdateCallback;
        this.beforeCreateCallback = beforeCreateCallback;
    }

    public SphereClient getCtpClient() {
        return this.ctpClient;
    }

    @Nullable
    public QuadConsumer<SyncException, Optional<V>, Optional<U>, List<UpdateAction<U>>> getErrorCallback() {
        return this.errorCallback;
    }

    @Nullable
    public TriConsumer<SyncException, Optional<V>, Optional<U>> getWarningCallback() {
        return this.warningCallback;
    }

    public void applyWarningCallback(@Nonnull SyncException exception, @Nullable U oldResource, @Nullable V newResourceDraft) {
        if (this.warningCallback != null) {
            this.warningCallback.accept(exception, Optional.ofNullable(newResourceDraft), Optional.ofNullable(oldResource));
        }
    }

    public void applyErrorCallback(@Nonnull SyncException exception, @Nullable U oldResource, @Nullable V newResourceDraft, @Nullable List<UpdateAction<U>> updateActions) {
        if (this.errorCallback != null) {
            this.errorCallback.accept(exception, Optional.ofNullable(newResourceDraft), Optional.ofNullable(oldResource), updateActions);
        }
    }

    public void applyErrorCallback(@Nonnull SyncException syncException) {
        this.applyErrorCallback(syncException, null, null, null);
    }

    public void applyErrorCallback(@Nonnull String errorMessage) {
        this.applyErrorCallback(new SyncException(errorMessage), null, null, null);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> getBeforeUpdateCallback() {
        return this.beforeUpdateCallback;
    }

    @Nullable
    public Function<V, V> getBeforeCreateCallback() {
        return this.beforeCreateCallback;
    }

    @Nonnull
    public List<UpdateAction<U>> applyBeforeUpdateCallback(@Nonnull List<UpdateAction<U>> updateActions, @Nonnull V newResourceDraft, @Nonnull U oldResource) {
        return Optional.ofNullable(this.beforeUpdateCallback).filter(callback -> !updateActions.isEmpty()).map(filteredCallback -> CollectionUtils.emptyIfNull((List)filteredCallback.apply(updateActions, newResourceDraft, oldResource))).orElse(updateActions);
    }

    @Nonnull
    public Optional<V> applyBeforeCreateCallback(@Nonnull V newResourceDraft) {
        return Optional.ofNullable(this.beforeCreateCallback != null ? this.beforeCreateCallback.apply(newResourceDraft) : newResourceDraft);
    }
}

