/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.inventory.InventoryEntryDraftBuilder;
import io.sphere.sdk.inventory.expansion.InventoryEntryExpansionModel;
import io.sphere.sdk.inventory.queries.InventoryEntryQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class InventoryReferenceResolutionUtils {
    @Nonnull
    public static List<InventoryEntryDraft> mapToInventoryEntryDrafts(@Nonnull List<InventoryEntry> inventoryEntries) {
        return inventoryEntries.stream().map(InventoryReferenceResolutionUtils::mapToInventoryEntryDraft).collect(Collectors.toList());
    }

    @Nonnull
    private static InventoryEntryDraft mapToInventoryEntryDraft(@Nonnull InventoryEntry inventoryEntry) {
        return InventoryEntryDraftBuilder.of((InventoryEntry)inventoryEntry).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(inventoryEntry)).supplyChannel(SyncUtils.getResourceIdentifierWithKey(inventoryEntry.getSupplyChannel())).build();
    }

    public static InventoryEntryQuery buildInventoryQuery() {
        return ((InventoryEntryQuery)((InventoryEntryQuery)InventoryEntryQuery.of().withLimit(500L)).withExpansionPaths(ExpansionPath.of((String)"custom.type"))).plusExpansionPaths(InventoryEntryExpansionModel::supplyChannel);
    }

    private InventoryReferenceResolutionUtils() {
    }
}

