/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.helpers.CategoryReferencePair;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.utils.VariantReferenceResolutionUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifiable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.CategoryOrderHints;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductData;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductDraftBuilder;
import io.sphere.sdk.products.ProductDraftDsl;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.ProductVariantDraftBuilder;
import io.sphere.sdk.products.ProductVariantDraftDsl;
import io.sphere.sdk.products.expansion.ProductExpansionModel;
import io.sphere.sdk.products.queries.ProductQuery;
import io.sphere.sdk.states.State;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductReferenceResolutionUtils {
    @Nonnull
    public static List<ProductDraft> mapToProductDrafts(@Nonnull List<Product> products) {
        return products.stream().filter(Objects::nonNull).map(product -> {
            ProductDraftDsl productDraft = ProductReferenceResolutionUtils.getDraftBuilderFromStagedProduct(product).build();
            CategoryReferencePair categoryReferencePair = ProductReferenceResolutionUtils.mapToCategoryReferencePair(product);
            Set<ResourceIdentifier<Category>> categoryResourceIdentifiers = categoryReferencePair.getCategoryResourceIdentifiers();
            CategoryOrderHints categoryOrderHintsWithKeys = categoryReferencePair.getCategoryOrderHints();
            List allVariants = product.getMasterData().getStaged().getAllVariants();
            List<ProductVariantDraft> variantDraftsWithKeys = VariantReferenceResolutionUtils.mapToProductVariantDrafts(allVariants);
            ProductVariantDraft masterVariantDraftWithKeys = variantDraftsWithKeys.remove(0);
            return ((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)ProductDraftBuilder.of((ProductDraft)productDraft).masterVariant(masterVariantDraftWithKeys)).variants(variantDraftsWithKeys).productType(SyncUtils.getResourceIdentifierWithKey(product.getProductType()))).categories(categoryResourceIdentifiers)).categoryOrderHints(categoryOrderHintsWithKeys)).taxCategory(SyncUtils.getResourceIdentifierWithKey(product.getTaxCategory()))).state(SyncUtils.getReferenceWithKeyReplaced(product.getState(), () -> State.referenceOfId((String)((State)product.getState().getObj()).getKey()))).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    public static ProductDraftBuilder getDraftBuilderFromStagedProduct(@Nonnull Product product) {
        ProductData productData = product.getMasterData().getStaged();
        List allVariants = productData.getAllVariants().stream().map(productVariant -> ProductVariantDraftBuilder.of((ProductVariant)productVariant).build()).collect(Collectors.toList());
        ProductVariantDraftDsl masterVariant = ProductVariantDraftBuilder.of((ProductVariant)product.getMasterData().getStaged().getMasterVariant()).build();
        return (ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)ProductDraftBuilder.of((ResourceIdentifiable)product.getProductType(), (LocalizedString)productData.getName(), (LocalizedString)productData.getSlug(), allVariants).masterVariant((ProductVariantDraft)masterVariant)).metaDescription(productData.getMetaDescription())).metaKeywords(productData.getMetaKeywords())).metaTitle(productData.getMetaTitle())).description(productData.getDescription())).searchKeywords(productData.getSearchKeywords())).taxCategory(product.getTaxCategory()).state((Referenceable)product.getState()).key(product.getKey())).publish(product.getMasterData().isPublished())).categories(new ArrayList(productData.getCategories())).categoryOrderHints(productData.getCategoryOrderHints());
    }

    @Nonnull
    static CategoryReferencePair mapToCategoryReferencePair(@Nonnull Product product) {
        Set categoryReferences = product.getMasterData().getStaged().getCategories();
        HashSet<ResourceIdentifier<Category>> categoryResourceIdentifiers = new HashSet<ResourceIdentifier<Category>>();
        CategoryOrderHints categoryOrderHints = product.getMasterData().getStaged().getCategoryOrderHints();
        HashMap categoryOrderHintsMapWithKeys = new HashMap();
        categoryReferences.forEach(categoryReference -> {
            if (categoryReference != null) {
                if (categoryReference.getObj() != null) {
                    String categoryOrderHintValue;
                    String categoryId = categoryReference.getId();
                    String categoryKey = ((Category)categoryReference.getObj()).getKey();
                    if (categoryOrderHints != null && (categoryOrderHintValue = categoryOrderHints.get(categoryId)) != null) {
                        categoryOrderHintsMapWithKeys.put(categoryKey, categoryOrderHintValue);
                    }
                    categoryResourceIdentifiers.add(ResourceIdentifier.ofKey((String)categoryKey));
                } else {
                    categoryResourceIdentifiers.add(ResourceIdentifier.ofId((String)categoryReference.getId()));
                }
            }
        });
        CategoryOrderHints categoryOrderHintsWithKeys = categoryOrderHintsMapWithKeys.isEmpty() ? categoryOrderHints : CategoryOrderHints.of(categoryOrderHintsMapWithKeys);
        return CategoryReferencePair.of(categoryResourceIdentifiers, categoryOrderHintsWithKeys);
    }

    @Nonnull
    public static ProductQuery buildProductQuery() {
        return (ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)ProductQuery.of().withLimit(500L)).withExpansionPaths(ProductExpansionModel::productType)).plusExpansionPaths(ProductExpansionModel::taxCategory)).plusExpansionPaths(ExpansionPath.of((String)"state"))).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().categories())).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().allVariants().prices().channel())).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().allVariants().prices().customerGroup())).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.masterVariant.prices[*].custom.type"))).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.variants[*].prices[*].custom.type"))).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().allVariants().attributes().value())).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().allVariants().attributes().valueSet())).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.masterVariant.assets[*].custom.type"))).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.variants[*].assets[*].custom.type"));
    }

    private ProductReferenceResolutionUtils() {
    }
}

