/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.commands.ProductCreateCommand;
import io.sphere.sdk.products.commands.ProductUpdateCommand;
import io.sphere.sdk.products.expansion.ProductExpansionModel;
import io.sphere.sdk.products.queries.ProductQuery;
import io.sphere.sdk.products.queries.ProductQueryModel;
import io.sphere.sdk.queries.QueryPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class ProductServiceImpl
extends BaseServiceWithKey<ProductDraft, Product, ProductSyncOptions, ProductQuery, ProductQueryModel, ProductExpansionModel<Product>>
implements ProductService {
    public ProductServiceImpl(@Nonnull ProductSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> getIdFromCacheOrFetch(@Nullable String key) {
        return this.fetchCachedResourceId(key, () -> (ProductQuery)ProductQuery.of().withPredicates(this.buildProductKeysQueryPredicate(Collections.singleton(key))));
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> productKeys) {
        return this.cacheKeysToIds(productKeys, keysNotCached -> (ProductQuery)ProductQuery.of().withPredicates(this.buildProductKeysQueryPredicate((Set<String>)keysNotCached)));
    }

    QueryPredicate<Product> buildProductKeysQueryPredicate(@Nonnull Set<String> productKeys) {
        List keysSurroundedWithDoubleQuotes = productKeys.stream().filter(StringUtils::isNotBlank).map(productKey -> String.format("\"%s\"", productKey)).collect(Collectors.toList());
        String keysQueryString = keysSurroundedWithDoubleQuotes.toString();
        keysQueryString = keysQueryString.substring(1, keysQueryString.length() - 1);
        return QueryPredicate.of((String)String.format("key in (%s)", keysQueryString));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Product>> fetchMatchingProductsByKeys(@Nonnull Set<String> productKeys) {
        return this.fetchMatchingResources(productKeys, () -> (ProductQuery)ProductQuery.of().withPredicates(this.buildProductKeysQueryPredicate(productKeys)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Product>> fetchProduct(@Nullable String key) {
        return this.fetchResource(key, () -> (ProductQuery)ProductQuery.of().withPredicates(this.buildProductKeysQueryPredicate(Collections.singleton(key))));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Product>> createProduct(@Nonnull ProductDraft productDraft) {
        return this.createResource(productDraft, ProductCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<Product> updateProduct(@Nonnull Product product, @Nonnull List<UpdateAction<Product>> updateActions) {
        return this.updateResource(product, ProductUpdateCommand::of, updateActions);
    }
}

