/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import io.sphere.sdk.producttypes.commands.ProductTypeCreateCommand;
import io.sphere.sdk.producttypes.commands.ProductTypeUpdateCommand;
import io.sphere.sdk.producttypes.expansion.ProductTypeExpansionModel;
import io.sphere.sdk.producttypes.queries.ProductTypeQuery;
import io.sphere.sdk.producttypes.queries.ProductTypeQueryBuilder;
import io.sphere.sdk.producttypes.queries.ProductTypeQueryModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductTypeServiceImpl
extends BaseServiceWithKey<ProductTypeDraft, ProductType, BaseSyncOptions, ProductTypeQuery, ProductTypeQueryModel, ProductTypeExpansionModel<ProductType>>
implements ProductTypeService {
    private final Map<String, Map<String, AttributeMetaData>> productsAttributesMetaData = new ConcurrentHashMap<String, Map<String, AttributeMetaData>>();

    public ProductTypeServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> keys) {
        return this.cacheKeysToIds(keys, keysNotCached -> ProductTypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn((Iterable)keysNotCached)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedProductTypeId(@Nonnull String key) {
        return this.fetchCachedResourceId(key, () -> ProductTypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn(Collections.singleton(key))).build());
    }

    @Nonnull
    private static Map<String, AttributeMetaData> getAttributeMetaDataMap(@Nonnull ProductType productType) {
        return productType.getAttributes().stream().map(AttributeMetaData::of).collect(Collectors.toMap(AttributeMetaData::getName, attributeMetaData -> attributeMetaData));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Map<String, AttributeMetaData>>> fetchCachedProductAttributeMetaDataMap(@Nonnull String productTypeId) {
        if (this.productsAttributesMetaData.isEmpty()) {
            return this.fetchAndCacheProductMetaData(productTypeId);
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(this.productsAttributesMetaData.get(productTypeId)));
    }

    @Nonnull
    private CompletionStage<Optional<Map<String, AttributeMetaData>>> fetchAndCacheProductMetaData(@Nonnull String productTypeId) {
        Consumer productTypePageConsumer = productTypePage -> productTypePage.forEach(type -> {
            String id = type.getId();
            this.productsAttributesMetaData.put(id, ProductTypeServiceImpl.getAttributeMetaDataMap(type));
        });
        return CtpQueryUtils.queryAll(this.syncOptions.getCtpClient(), ProductTypeQuery.of(), productTypePageConsumer).thenApply(result -> Optional.ofNullable(this.productsAttributesMetaData.get(productTypeId)));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<ProductType>> fetchMatchingProductTypesByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, () -> ProductTypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn((Iterable)keys)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductType>> createProductType(@Nonnull ProductTypeDraft productTypeDraft) {
        return this.createResource(productTypeDraft, ProductTypeCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<ProductType> updateProductType(@Nonnull ProductType productType, @Nonnull List<UpdateAction<ProductType>> updateActions) {
        return this.updateResource(productType, ProductTypeUpdateCommand::of, updateActions);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductType>> fetchProductType(@Nullable String key) {
        return this.fetchResource(key, () -> ProductTypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().is(key)).build());
    }
}

