/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.types.CustomFieldsDraft;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class BaseBatchValidator<D, O extends BaseSyncOptions, S extends BaseSyncStatistics> {
    private final O syncOptions;
    private final S syncStatistics;

    public BaseBatchValidator(@Nonnull O syncOptions, @Nonnull S syncStatistics) {
        this.syncOptions = syncOptions;
        this.syncStatistics = syncStatistics;
    }

    public abstract ImmutablePair<Set<D>, ?> validateAndCollectReferencedKeys(@Nonnull List<D> var1);

    protected <T> void collectReferencedKeyFromResourceIdentifier(@Nullable ResourceIdentifier<T> resourceIdentifier, @Nonnull Consumer<String> keyConsumer) {
        if (resourceIdentifier != null && !StringUtils.isBlank((CharSequence)resourceIdentifier.getKey())) {
            keyConsumer.accept(resourceIdentifier.getKey());
        }
    }

    protected void collectReferencedKeyFromCustomFieldsDraft(@Nullable CustomFieldsDraft customFieldsDraft, @Nonnull Consumer<String> keyConsumer) {
        if (customFieldsDraft != null) {
            this.collectReferencedKeyFromResourceIdentifier(customFieldsDraft.getType(), keyConsumer);
        }
    }

    protected void collectReferencedKeysFromAssetDrafts(@Nullable List<AssetDraft> assetDrafts, @Nonnull Consumer<String> keyConsumer) {
        if (assetDrafts != null) {
            assetDrafts.forEach(assetDraft -> this.collectReferencedKeyFromCustomFieldsDraft(assetDraft.getCustom(), keyConsumer));
        }
    }

    protected <T> void collectReferencedKeyFromReference(@Nullable Reference<T> reference, @Nonnull Consumer<String> keyInReferenceSupplier) {
        if (reference != null && !StringUtils.isBlank((CharSequence)reference.getId())) {
            keyInReferenceSupplier.accept(reference.getId());
        }
    }

    protected void handleError(@Nonnull SyncException syncException) {
        ((BaseSyncOptions)this.syncOptions).applyErrorCallback(syncException);
        ((BaseSyncStatistics)this.syncStatistics).incrementFailed();
    }

    protected void handleError(@Nonnull String errorMessage) {
        this.handleError(new SyncException(errorMessage));
    }
}

