/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.utils.StreamUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class CompletableFutureUtils {
    @Nonnull
    public static <T, S, U extends Collection<S>> CompletableFuture<U> mapValuesToFutureOfCompletedValues(@Nonnull Collection<T> values, @Nonnull Function<T, CompletionStage<S>> mapper, @Nonnull Collector<S, ?, U> collector) {
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(values.stream(), mapper, collector);
    }

    @Nonnull
    public static <T, S> CompletableFuture<Stream<S>> mapValuesToFutureOfCompletedValues(@Nonnull Collection<T> values, @Nonnull Function<T, CompletionStage<S>> mapper) {
        List futureList = CompletableFutureUtils.mapValuesToFutures(values.stream(), mapper, Collectors.toList());
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futureList, Collectors.toList()).thenApply(Collection::stream);
    }

    @Nonnull
    public static <T, S, U extends Collection<S>> CompletableFuture<U> mapValuesToFutureOfCompletedValues(@Nonnull Stream<T> values, @Nonnull Function<T, CompletionStage<S>> mapper, @Nonnull Collector<S, ?, U> collector) {
        List futureList = CompletableFutureUtils.mapValuesToFutures(values, mapper, Collectors.toList());
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futureList, collector);
    }

    @Nonnull
    public static <T, S extends Collection<T>> CompletableFuture<S> collectionOfFuturesToFutureOfCollection(@Nonnull Collection<? extends CompletionStage<T>> futures, @Nonnull Collector<T, ?, S> collector) {
        List<CompletableFuture> futureList = futures.stream().filter(Objects::nonNull).map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
        CompletableFuture[] futuresAsArray = futureList.toArray(new CompletableFuture[futureList.size()]);
        return CompletableFuture.allOf(futuresAsArray).thenApply(ignoredResult -> (Collection)futureList.stream().map(CompletableFuture::join).collect(collector));
    }

    @Nonnull
    public static <T, S, U extends Collection<CompletableFuture<S>>> U mapValuesToFutures(@Nonnull Stream<T> values, @Nonnull Function<T, CompletionStage<S>> mapper, @Nonnull Collector<CompletableFuture<S>, ?, U> collector) {
        Stream<CompletionStage<T>> stageStream = StreamUtils.filterNullAndMap(values, mapper);
        return CompletableFutureUtils.toCompletableFutures(stageStream, collector);
    }

    @Nonnull
    public static <T, S extends Collection<CompletableFuture<T>>> S toCompletableFutures(@Nonnull Stream<CompletionStage<T>> values, @Nonnull Collector<CompletableFuture<T>, ?, S> collector) {
        return (S)((Collection)values.filter(Objects::nonNull).map(CompletionStage::toCompletableFuture).collect(collector));
    }

    private CompletableFutureUtils() {
    }
}

