/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.models.WithKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SyncUtils {
    private static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}";

    public static <T> List<List<T>> batchElements(@Nonnull List<T> elements, int batchSize) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        for (int i = 0; i < elements.size() && batchSize > 0; i += batchSize) {
            batches.add(elements.subList(i, Math.min(i + batchSize, elements.size())));
        }
        return batches;
    }

    @Nullable
    public static <T> Reference<T> getReferenceWithKeyReplaced(@Nullable Reference<T> reference, @Nonnull Supplier<Reference<T>> keyInReferenceSupplier) {
        if (reference != null && reference.getObj() != null) {
            return keyInReferenceSupplier.get();
        }
        return reference;
    }

    @Nullable
    public static <T extends WithKey> ResourceIdentifier<T> getResourceIdentifierWithKey(@Nullable Reference<T> reference) {
        if (reference != null) {
            if (reference.getObj() != null) {
                return ResourceIdentifier.ofKey((String)((WithKey)reference.getObj()).getKey());
            }
            return ResourceIdentifier.ofId((String)reference.getId());
        }
        return null;
    }

    public static boolean isUuid(@Nonnull String id) {
        Pattern regexPattern = Pattern.compile(UUID_REGEX);
        return regexPattern.matcher(id).matches();
    }

    private SyncUtils() {
    }
}

