/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.utils;

import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.customers.commands.updateactions.AddBillingAddressIdWithKey;
import com.commercetools.sync.customers.commands.updateactions.AddShippingAddressIdWithKey;
import com.commercetools.sync.customers.commands.updateactions.SetDefaultBillingAddressWithKey;
import com.commercetools.sync.customers.commands.updateactions.SetDefaultShippingAddressWithKey;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.customergroups.CustomerGroup;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.customers.CustomerDraft;
import io.sphere.sdk.customers.commands.updateactions.AddAddress;
import io.sphere.sdk.customers.commands.updateactions.AddStore;
import io.sphere.sdk.customers.commands.updateactions.ChangeAddress;
import io.sphere.sdk.customers.commands.updateactions.ChangeEmail;
import io.sphere.sdk.customers.commands.updateactions.RemoveAddress;
import io.sphere.sdk.customers.commands.updateactions.RemoveBillingAddressId;
import io.sphere.sdk.customers.commands.updateactions.RemoveShippingAddressId;
import io.sphere.sdk.customers.commands.updateactions.RemoveStore;
import io.sphere.sdk.customers.commands.updateactions.SetCompanyName;
import io.sphere.sdk.customers.commands.updateactions.SetCustomerGroup;
import io.sphere.sdk.customers.commands.updateactions.SetCustomerNumber;
import io.sphere.sdk.customers.commands.updateactions.SetDateOfBirth;
import io.sphere.sdk.customers.commands.updateactions.SetExternalId;
import io.sphere.sdk.customers.commands.updateactions.SetFirstName;
import io.sphere.sdk.customers.commands.updateactions.SetLastName;
import io.sphere.sdk.customers.commands.updateactions.SetLocale;
import io.sphere.sdk.customers.commands.updateactions.SetMiddleName;
import io.sphere.sdk.customers.commands.updateactions.SetSalutation;
import io.sphere.sdk.customers.commands.updateactions.SetStores;
import io.sphere.sdk.customers.commands.updateactions.SetTitle;
import io.sphere.sdk.customers.commands.updateactions.SetVatId;
import io.sphere.sdk.models.Address;
import io.sphere.sdk.models.KeyReference;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.models.ResourceImpl;
import io.sphere.sdk.stores.Store;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomerUpdateActionUtils {
    public static final String CUSTOMER_NUMBER_EXISTS_WARNING = "Customer with key: \"%s\" has already a customer number: \"%s\", once it's set it cannot be changed. Hereby, the update action is not created.";

    private CustomerUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildChangeEmailUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getEmail(), newCustomer.getEmail(), () -> ChangeEmail.of((String)newCustomer.getEmail()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetFirstNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getFirstName(), newCustomer.getFirstName(), () -> SetFirstName.of((String)newCustomer.getFirstName()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetLastNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getLastName(), newCustomer.getLastName(), () -> SetLastName.of((String)newCustomer.getLastName()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetMiddleNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getMiddleName(), newCustomer.getMiddleName(), () -> SetMiddleName.of((String)newCustomer.getMiddleName()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetTitleUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getTitle(), newCustomer.getTitle(), () -> SetTitle.of((String)newCustomer.getTitle()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetSalutationUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getSalutation(), newCustomer.getSalutation(), () -> SetSalutation.of((String)newCustomer.getSalutation()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetCustomerNumberUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer, @Nonnull CustomerSyncOptions syncOptions) {
        Optional<UpdateAction<Customer>> setCustomerNumberAction = CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getCustomerNumber(), newCustomer.getCustomerNumber(), () -> SetCustomerNumber.of((String)newCustomer.getCustomerNumber()));
        if (setCustomerNumberAction.isPresent() && !StringUtils.isBlank((CharSequence)oldCustomer.getCustomerNumber())) {
            syncOptions.applyWarningCallback(new SyncException(String.format(CUSTOMER_NUMBER_EXISTS_WARNING, oldCustomer.getKey(), oldCustomer.getCustomerNumber())), oldCustomer, newCustomer);
            return Optional.empty();
        }
        return setCustomerNumberAction;
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetExternalIdUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getExternalId(), newCustomer.getExternalId(), () -> SetExternalId.of((String)newCustomer.getExternalId()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetCompanyNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getCompanyName(), newCustomer.getCompanyName(), () -> SetCompanyName.of((String)newCustomer.getCompanyName()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetDateOfBirthUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getDateOfBirth(), newCustomer.getDateOfBirth(), () -> SetDateOfBirth.of((LocalDate)newCustomer.getDateOfBirth()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetVatIdUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getVatId(), newCustomer.getVatId(), () -> SetVatId.of((String)newCustomer.getVatId()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetLocaleUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getLocale(), newCustomer.getLocale(), () -> SetLocale.of((Locale)newCustomer.getLocale()));
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetCustomerGroupUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldCustomer.getCustomerGroup(), newCustomer.getCustomerGroup(), () -> SetCustomerGroup.of(CustomerUpdateActionUtils.mapResourceIdentifierToReferenceable((ResourceIdentifier<CustomerGroup>)newCustomer.getCustomerGroup())));
    }

    @Nullable
    private static Referenceable<CustomerGroup> mapResourceIdentifierToReferenceable(final @Nullable ResourceIdentifier<CustomerGroup> resourceIdentifier) {
        if (resourceIdentifier == null) {
            return null;
        }
        return new ResourceImpl<CustomerGroup>(null, null, null, null){

            public Reference<CustomerGroup> toReference() {
                return Reference.of((String)CustomerGroup.referenceTypeId(), (String)resourceIdentifier.getId());
            }
        };
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildStoreUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        List oldStores = oldCustomer.getStores();
        List newStores = newCustomer.getStores();
        return CustomerUpdateActionUtils.buildSetStoreUpdateAction(oldStores, newStores).map(Collections::singletonList).orElseGet(() -> CustomerUpdateActionUtils.prepareStoreActions(oldStores, newStores));
    }

    private static List<UpdateAction<Customer>> prepareStoreActions(@Nullable List<KeyReference<Store>> oldStores, @Nullable List<ResourceIdentifier<Store>> newStores) {
        if (oldStores != null && newStores != null) {
            List<UpdateAction<Customer>> removeStoreUpdateActions = CustomerUpdateActionUtils.buildRemoveStoreUpdateActions(oldStores, newStores);
            List<UpdateAction<Customer>> addStoreUpdateActions = CustomerUpdateActionUtils.buildAddStoreUpdateActions(oldStores, newStores);
            if (!removeStoreUpdateActions.isEmpty() && !addStoreUpdateActions.isEmpty()) {
                return CustomerUpdateActionUtils.buildSetStoreUpdateAction(newStores).map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
            return removeStoreUpdateActions.isEmpty() ? addStoreUpdateActions : removeStoreUpdateActions;
        }
        return Collections.emptyList();
    }

    @Nonnull
    private static Optional<UpdateAction<Customer>> buildSetStoreUpdateAction(@Nullable List<KeyReference<Store>> oldStores, @Nullable List<ResourceIdentifier<Store>> newStores) {
        if (oldStores != null && !oldStores.isEmpty()) {
            if (newStores == null || newStores.isEmpty()) {
                return Optional.of(SetStores.of(Collections.emptyList()));
            }
        } else if (newStores != null && !newStores.isEmpty()) {
            return CustomerUpdateActionUtils.buildSetStoreUpdateAction(newStores);
        }
        return Optional.empty();
    }

    private static Optional<UpdateAction<Customer>> buildSetStoreUpdateAction(@Nonnull List<ResourceIdentifier<Store>> newStores) {
        List stores = newStores.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!stores.isEmpty()) {
            return Optional.of(SetStores.of(stores));
        }
        return Optional.empty();
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildRemoveStoreUpdateActions(@Nonnull List<KeyReference<Store>> oldStores, @Nonnull List<ResourceIdentifier<Store>> newStores) {
        Map newStoreKeyToStoreMap = newStores.stream().filter(Objects::nonNull).filter(storeResourceIdentifier -> storeResourceIdentifier.getKey() != null).collect(Collectors.toMap(ResourceIdentifier::getKey, Function.identity()));
        return oldStores.stream().filter(Objects::nonNull).filter(storeKeyReference -> !newStoreKeyToStoreMap.containsKey(storeKeyReference.getKey())).map(storeKeyReference -> RemoveStore.of((ResourceIdentifier)ResourceIdentifier.ofKey((String)storeKeyReference.getKey()))).collect(Collectors.toList());
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildAddStoreUpdateActions(@Nonnull List<KeyReference<Store>> oldStores, @Nonnull List<ResourceIdentifier<Store>> newStores) {
        Map oldStoreKeyToStoreMap = oldStores.stream().filter(Objects::nonNull).collect(Collectors.toMap(KeyReference::getKey, Function.identity()));
        return newStores.stream().filter(Objects::nonNull).filter(storeResourceIdentifier -> !oldStoreKeyToStoreMap.containsKey(storeResourceIdentifier.getKey())).map(AddStore::of).collect(Collectors.toList());
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildAllAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        ArrayList<UpdateAction<Customer>> addressActions = new ArrayList<UpdateAction<Customer>>();
        List<UpdateAction<Customer>> removeAddressActions = CustomerUpdateActionUtils.buildRemoveAddressUpdateActions(oldCustomer, newCustomer);
        addressActions.addAll(removeAddressActions);
        addressActions.addAll(CustomerUpdateActionUtils.buildChangeAddressUpdateActions(oldCustomer, newCustomer));
        addressActions.addAll(CustomerUpdateActionUtils.buildAddAddressUpdateActions(oldCustomer, newCustomer));
        addressActions.addAll(CustomerUpdateActionUtils.collectAndFilterRemoveShippingAndBillingActions(removeAddressActions, oldCustomer, newCustomer));
        CustomerUpdateActionUtils.buildSetDefaultShippingAddressUpdateAction(oldCustomer, newCustomer).ifPresent(addressActions::add);
        CustomerUpdateActionUtils.buildSetDefaultBillingAddressUpdateAction(oldCustomer, newCustomer).ifPresent(addressActions::add);
        addressActions.addAll(CustomerUpdateActionUtils.buildAddShippingAddressUpdateActions(oldCustomer, newCustomer));
        addressActions.addAll(CustomerUpdateActionUtils.buildAddBillingAddressUpdateActions(oldCustomer, newCustomer));
        return addressActions;
    }

    @Nonnull
    private static List<UpdateAction<Customer>> collectAndFilterRemoveShippingAndBillingActions(@Nonnull List<UpdateAction<Customer>> removeAddressActions, @Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        Set addressIdsToRemove = removeAddressActions.stream().map(customerUpdateAction -> (RemoveAddress)customerUpdateAction).map(RemoveAddress::getAddressId).collect(Collectors.toSet());
        ArrayList<UpdateAction<Customer>> removeActions = new ArrayList<UpdateAction<Customer>>();
        removeActions.addAll(CustomerUpdateActionUtils.buildRemoveShippingAddressUpdateActions(oldCustomer, newCustomer).stream().map(customerUpdateAction -> (RemoveShippingAddressId)customerUpdateAction).filter(action -> !addressIdsToRemove.contains(action.getAddressId())).collect(Collectors.toList()));
        removeActions.addAll(CustomerUpdateActionUtils.buildRemoveBillingAddressUpdateActions(oldCustomer, newCustomer).stream().map(customerUpdateAction -> (RemoveBillingAddressId)customerUpdateAction).filter(action -> !addressIdsToRemove.contains(action.getAddressId())).collect(Collectors.toList()));
        return removeActions;
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildRemoveAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (oldCustomer.getAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        if (newCustomer.getAddresses() == null || newCustomer.getAddresses().isEmpty()) {
            return oldCustomer.getAddresses().stream().map(address -> RemoveAddress.of((String)address.getId())).collect(Collectors.toList());
        }
        Set newAddressKeys = newCustomer.getAddresses().stream().filter(Objects::nonNull).filter(newAddress -> !StringUtils.isBlank((CharSequence)newAddress.getKey())).map(Address::getKey).collect(Collectors.toSet());
        return oldCustomer.getAddresses().stream().filter(oldAddress -> StringUtils.isBlank((CharSequence)oldAddress.getKey()) || !newAddressKeys.contains(oldAddress.getKey())).map(RemoveAddress::of).collect(Collectors.toList());
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildChangeAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (newCustomer.getAddresses() == null || newCustomer.getAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = oldCustomer.getAddresses().stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(Address::getKey, Function.identity()));
        return newCustomer.getAddresses().stream().filter(Objects::nonNull).filter(newAddress -> !StringUtils.isBlank((CharSequence)newAddress.getKey())).filter(newAddress -> oldAddressKeyToAddressMap.containsKey(newAddress.getKey())).map(newAddress -> {
            Address oldAddress = (Address)oldAddressKeyToAddressMap.get(newAddress.getKey());
            if (!newAddress.equalsIgnoreId(oldAddress)) {
                return ChangeAddress.of((String)oldAddress.getId(), (Address)newAddress);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildAddAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (newCustomer.getAddresses() == null || newCustomer.getAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = oldCustomer.getAddresses().stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(Address::getKey, Function.identity()));
        return newCustomer.getAddresses().stream().filter(Objects::nonNull).filter(newAddress -> !StringUtils.isBlank((CharSequence)newAddress.getKey())).filter(newAddress -> !oldAddressKeyToAddressMap.containsKey(newAddress.getKey())).map(AddAddress::of).collect(Collectors.toList());
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetDefaultShippingAddressUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        Address oldAddress = oldCustomer.getDefaultShippingAddress();
        String newAddressKey = CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), newCustomer.getDefaultShippingAddress());
        if (newAddressKey != null) {
            if (oldAddress == null || !Objects.equals(oldAddress.getKey(), newAddressKey)) {
                return Optional.of(SetDefaultShippingAddressWithKey.of(newAddressKey));
            }
        } else if (oldAddress != null) {
            return Optional.of(SetDefaultShippingAddressWithKey.of(null));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<UpdateAction<Customer>> buildSetDefaultBillingAddressUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        Address oldAddress = oldCustomer.getDefaultBillingAddress();
        String newAddressKey = CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), newCustomer.getDefaultBillingAddress());
        if (newAddressKey != null) {
            if (oldAddress == null || !Objects.equals(oldAddress.getKey(), newAddressKey)) {
                return Optional.of(SetDefaultBillingAddressWithKey.of(newAddressKey));
            }
        } else if (oldAddress != null) {
            return Optional.of(SetDefaultBillingAddressWithKey.of(null));
        }
        return Optional.empty();
    }

    @Nullable
    private static String getAddressKeyAt(@Nullable List<Address> addressList, @Nullable Integer index) {
        if (index == null) {
            return null;
        }
        if (addressList == null || index < 0 || index >= addressList.size()) {
            throw new IllegalArgumentException(String.format("Addresses list does not contain an address at the index: %s", index));
        }
        Address address = addressList.get(index);
        if (address == null) {
            throw new IllegalArgumentException(String.format("Address is null at the index: %s of the addresses list.", index));
        }
        if (StringUtils.isBlank((CharSequence)address.getKey())) {
            throw new IllegalArgumentException(String.format("Address does not have a key at the index: %s of the addresses list.", index));
        }
        return address.getKey();
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildAddShippingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (newCustomer.getShippingAddresses() == null || newCustomer.getShippingAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = oldCustomer.getShippingAddresses().stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(Address::getKey, Function.identity()));
        Set newAddressKeys = newCustomer.getShippingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return newAddressKeys.stream().filter(newAddressKey -> !oldAddressKeyToAddressMap.containsKey(newAddressKey)).map(AddShippingAddressIdWithKey::of).collect(Collectors.toList());
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildRemoveShippingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (oldCustomer.getShippingAddresses() == null || oldCustomer.getShippingAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        if (newCustomer.getShippingAddresses() == null || newCustomer.getShippingAddresses().isEmpty()) {
            return oldCustomer.getShippingAddresses().stream().map(address -> RemoveShippingAddressId.of((String)address.getId())).collect(Collectors.toList());
        }
        Set newAddressKeys = newCustomer.getShippingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return oldCustomer.getShippingAddresses().stream().filter(address -> StringUtils.isBlank((CharSequence)address.getKey()) || !newAddressKeys.contains(address.getKey())).map(address -> RemoveShippingAddressId.of((String)address.getId())).collect(Collectors.toList());
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildAddBillingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (newCustomer.getBillingAddresses() == null || newCustomer.getBillingAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = oldCustomer.getBillingAddresses().stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(Address::getKey, Function.identity()));
        Set newAddressKeys = newCustomer.getBillingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return newAddressKeys.stream().filter(newAddressKey -> !oldAddressKeyToAddressMap.containsKey(newAddressKey)).map(AddBillingAddressIdWithKey::of).collect(Collectors.toList());
    }

    @Nonnull
    public static List<UpdateAction<Customer>> buildRemoveBillingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (oldCustomer.getBillingAddresses() == null || oldCustomer.getBillingAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        if (newCustomer.getBillingAddresses() == null || newCustomer.getBillingAddresses().isEmpty()) {
            return oldCustomer.getBillingAddresses().stream().map(address -> RemoveBillingAddressId.of((String)address.getId())).collect(Collectors.toList());
        }
        Set newAddressKeys = newCustomer.getBillingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return oldCustomer.getBillingAddresses().stream().filter(address -> StringUtils.isBlank((CharSequence)address.getKey()) || !newAddressKeys.contains(address.getKey())).map(address -> RemoveBillingAddressId.of((String)address.getId())).collect(Collectors.toList());
    }
}

