/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.templates.beforeupdatecallback;

import com.commercetools.sync.commons.utils.OptionalUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.LocalizedStringEntry;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductData;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductDraftBuilder;
import io.sphere.sdk.products.commands.updateactions.ChangeName;
import io.sphere.sdk.products.commands.updateactions.ChangeSlug;
import io.sphere.sdk.products.commands.updateactions.SetDescription;
import io.sphere.sdk.products.commands.updateactions.SetMetaDescription;
import io.sphere.sdk.products.commands.updateactions.SetMetaKeywords;
import io.sphere.sdk.products.commands.updateactions.SetMetaTitle;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SyncSingleLocale {
    @Nonnull
    public static List<UpdateAction<Product>> syncFrenchDataOnly(@Nonnull List<UpdateAction<Product>> updateActions, @Nonnull ProductDraft newProductDraft, @Nonnull Product oldProduct) {
        List optionalActions = updateActions.stream().map(action -> SyncSingleLocale.filterSingleLocalization((UpdateAction<Product>)action, newProductDraft, oldProduct, Locale.FRENCH)).collect(Collectors.toList());
        return OptionalUtils.filterEmptyOptionals(optionalActions);
    }

    @Nonnull
    private static Optional<UpdateAction<Product>> filterSingleLocalization(@Nonnull UpdateAction<Product> updateAction, @Nonnull ProductDraft newProductDraft, @Nonnull Product oldProduct, @Nonnull Locale locale) {
        if (updateAction instanceof ChangeName) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getName, ProductData::getName, ChangeName::of);
        }
        if (updateAction instanceof SetDescription) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getDescription, ProductData::getDescription, SetDescription::of);
        }
        if (updateAction instanceof ChangeSlug) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getSlug, ProductData::getSlug, ChangeSlug::of);
        }
        if (updateAction instanceof SetMetaTitle) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getMetaTitle, ProductData::getMetaTitle, SetMetaTitle::of);
        }
        if (updateAction instanceof SetMetaDescription) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getMetaDescription, ProductData::getMetaDescription, SetMetaDescription::of);
        }
        if (updateAction instanceof SetMetaKeywords) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getMetaKeywords, ProductData::getMetaKeywords, SetMetaKeywords::of);
        }
        return Optional.of(updateAction);
    }

    @Nonnull
    private static Optional<UpdateAction<Product>> filterLocalizedField(@Nonnull ProductDraft newDraft, @Nonnull Product oldProduct, @Nonnull Locale locale, @Nonnull Function<ProductDraft, LocalizedString> newLocalizedFieldMapper, @Nonnull Function<ProductData, LocalizedString> oldLocalizedFieldMapper, @Nonnull Function<LocalizedString, UpdateAction<Product>> updateActionMapper) {
        LocalizedString newLocalizedField = newLocalizedFieldMapper.apply(newDraft);
        LocalizedString oldLocalizedField = oldLocalizedFieldMapper.apply(oldProduct.getMasterData().getStaged());
        if (oldLocalizedField != null && newLocalizedField != null) {
            String newLocaleValue = newLocalizedField.get(locale);
            String oldLocaleValue = oldLocalizedField.get(locale);
            LocalizedString withLocaleChange = Optional.ofNullable(oldLocaleValue).map(value -> LocalizedString.of(oldLocalizedField.stream().filter(localization -> !localization.getLocale().equals(locale)).collect(Collectors.toMap(LocalizedStringEntry::getLocale, LocalizedStringEntry::getValue)))).orElse(oldLocalizedField);
            return Optional.ofNullable(Optional.ofNullable(newLocaleValue).map(val -> (UpdateAction)updateActionMapper.apply(withLocaleChange.plus(locale, val))).orElseGet(() -> (UpdateAction)updateActionMapper.apply(withLocaleChange)));
        }
        if (oldLocalizedField != null) {
            return Optional.ofNullable(oldLocalizedField.get(locale)).map(localValue -> (UpdateAction)updateActionMapper.apply(LocalizedString.empty()));
        }
        return Optional.ofNullable(newLocalizedField.get(locale)).map(newLocalValue -> (UpdateAction)updateActionMapper.apply(LocalizedString.of((Locale)locale, (String)newLocalValue)));
    }

    @Nonnull
    public static ProductDraft filterFrenchLocales(@Nonnull ProductDraft productDraft) {
        return SyncSingleLocale.filterLocalizedStrings(productDraft, Locale.FRENCH);
    }

    @Nonnull
    private static ProductDraft filterLocalizedStrings(@Nonnull ProductDraft productDraft, @Nonnull Locale locale) {
        LocalizedString name = productDraft.getName();
        LocalizedString slug = productDraft.getSlug();
        LocalizedString description = productDraft.getDescription();
        LocalizedString metaDescription = productDraft.getMetaDescription();
        LocalizedString metaKeywords = productDraft.getMetaKeywords();
        LocalizedString metaTitle = productDraft.getMetaTitle();
        return ((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)ProductDraftBuilder.of((ProductDraft)productDraft).name(SyncSingleLocale.filterLocale(name, locale))).slug(SyncSingleLocale.filterLocale(slug, locale))).description(SyncSingleLocale.filterLocale(description, locale))).metaDescription(SyncSingleLocale.filterLocale(metaDescription, locale))).metaKeywords(SyncSingleLocale.filterLocale(metaKeywords, locale))).metaTitle(SyncSingleLocale.filterLocale(metaTitle, locale))).build();
    }

    @Nullable
    private static LocalizedString filterLocale(@Nullable LocalizedString localizedString, @Nonnull Locale locale) {
        return Optional.ofNullable(localizedString).map(lText -> lText.stream().filter(localizedStringEntry -> Objects.equals(localizedStringEntry.getLocale(), locale)).collect(Collectors.toMap(LocalizedStringEntry::getLocale, LocalizedStringEntry::getValue))).map(LocalizedString::of).orElse(null);
    }

    private SyncSingleLocale() {
    }
}

