/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.FilterUtils;
import com.commercetools.sync.internals.utils.UnorderedCollectionSyncUtils;
import com.commercetools.sync.products.ActionGroup;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.SyncFilter;
import com.commercetools.sync.products.utils.ProductVariantUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.CategoryOrderHints;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.commands.updateactions.AddAsset;
import io.sphere.sdk.products.commands.updateactions.AddToCategory;
import io.sphere.sdk.products.commands.updateactions.AddVariant;
import io.sphere.sdk.products.commands.updateactions.ChangeMasterVariant;
import io.sphere.sdk.products.commands.updateactions.ChangeName;
import io.sphere.sdk.products.commands.updateactions.ChangeSlug;
import io.sphere.sdk.products.commands.updateactions.Publish;
import io.sphere.sdk.products.commands.updateactions.RemoveFromCategory;
import io.sphere.sdk.products.commands.updateactions.RemoveVariant;
import io.sphere.sdk.products.commands.updateactions.SetAttributeInAllVariants;
import io.sphere.sdk.products.commands.updateactions.SetCategoryOrderHint;
import io.sphere.sdk.products.commands.updateactions.SetDescription;
import io.sphere.sdk.products.commands.updateactions.SetMetaDescription;
import io.sphere.sdk.products.commands.updateactions.SetMetaKeywords;
import io.sphere.sdk.products.commands.updateactions.SetMetaTitle;
import io.sphere.sdk.products.commands.updateactions.SetSearchKeywords;
import io.sphere.sdk.products.commands.updateactions.SetTaxCategory;
import io.sphere.sdk.products.commands.updateactions.TransitionState;
import io.sphere.sdk.products.commands.updateactions.Unpublish;
import io.sphere.sdk.search.SearchKeywords;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public final class ProductUpdateActionUtils {
    private static final String BLANK_VARIANT_KEY = "The variant key is blank.";
    private static final String NULL_VARIANT = "The variant is null.";
    static final String BLANK_OLD_MASTER_VARIANT_KEY = "Old master variant key is blank.";
    static final String BLANK_NEW_MASTER_VARIANT_KEY = "New master variant null or has blank key.";
    static final String BLANK_NEW_MASTER_VARIANT_SKU = "New master variant has blank SKU.";

    @Nonnull
    public static Optional<UpdateAction<Product>> buildChangeNameUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newName = newProduct.getName();
        LocalizedString oldName = oldProduct.getMasterData().getStaged().getName();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldName, newName, () -> ChangeName.of((LocalizedString)newName, (Boolean)true));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetDescriptionUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newDescription = newProduct.getDescription();
        LocalizedString oldDescription = oldProduct.getMasterData().getStaged().getDescription();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldDescription, newDescription, () -> SetDescription.of((LocalizedString)newDescription, (Boolean)true));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildChangeSlugUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newSlug = newProduct.getSlug();
        LocalizedString oldSlug = oldProduct.getMasterData().getStaged().getSlug();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldSlug, newSlug, () -> ChangeSlug.of((LocalizedString)newSlug, (Boolean)true));
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildAddToCategoryUpdateActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        Set newCategories = newProduct.getCategories();
        Set oldCategories = oldProduct.getMasterData().getStaged().getCategories();
        return CommonTypeUpdateActionUtils.buildUpdateActions(oldCategories, newCategories, () -> {
            ArrayList updateActions = new ArrayList();
            List<ResourceIdentifier> newCategoriesResourceIdentifiers = CollectionUtils.filterCollection(newCategories, newCategoryReference -> oldCategories.stream().map(Reference::toResourceIdentifier).noneMatch(oldResourceIdentifier -> oldResourceIdentifier.equals(newCategoryReference))).collect(Collectors.toList());
            newCategoriesResourceIdentifiers.forEach(categoryResourceIdentifier -> updateActions.add(AddToCategory.of((ResourceIdentifier)categoryResourceIdentifier, (Boolean)true)));
            return updateActions;
        });
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildSetCategoryOrderHintUpdateActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        CategoryOrderHints newCategoryOrderHints = newProduct.getCategoryOrderHints();
        CategoryOrderHints oldCategoryOrderHints = oldProduct.getMasterData().getStaged().getCategoryOrderHints();
        return CommonTypeUpdateActionUtils.buildUpdateActions(oldCategoryOrderHints, newCategoryOrderHints, () -> {
            Set newCategoryIds = newProduct.getCategories().stream().map(ResourceIdentifier::getId).collect(Collectors.toSet());
            ArrayList updateActions = new ArrayList();
            Map newMap = Objects.nonNull(newCategoryOrderHints) ? newCategoryOrderHints.getAsMap() : Collections.emptyMap();
            Map oldMap = Objects.nonNull(oldCategoryOrderHints) ? oldCategoryOrderHints.getAsMap() : Collections.emptyMap();
            oldMap.forEach((categoryId, value) -> {
                if (!newMap.containsKey(categoryId) && newCategoryIds.contains(categoryId)) {
                    updateActions.add(SetCategoryOrderHint.of((String)categoryId, null, (Boolean)true));
                }
            });
            newMap.forEach((key, value) -> {
                if (!oldMap.containsKey(key) || !Objects.equals(oldMap.get(key), value)) {
                    updateActions.add(SetCategoryOrderHint.of((String)key, (String)value, (Boolean)true));
                }
            });
            return updateActions;
        });
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildRemoveFromCategoryUpdateActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        Set newCategories = newProduct.getCategories();
        Set oldCategories = oldProduct.getMasterData().getStaged().getCategories();
        return CommonTypeUpdateActionUtils.buildUpdateActions(oldCategories, newCategories, () -> {
            ArrayList updateActions = new ArrayList();
            CollectionUtils.filterCollection(oldCategories, oldCategoryReference -> !newCategories.contains(oldCategoryReference.toResourceIdentifier())).forEach(categoryReference -> updateActions.add(RemoveFromCategory.of((ResourceIdentifier)categoryReference.toResourceIdentifier(), (Boolean)true)));
            return updateActions;
        });
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetSearchKeywordsUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        SearchKeywords newSearchKeywords = newProduct.getSearchKeywords();
        SearchKeywords oldSearchKeywords = oldProduct.getMasterData().getStaged().getSearchKeywords();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldSearchKeywords, newSearchKeywords, () -> SetSearchKeywords.of((SearchKeywords)newSearchKeywords, (Boolean)true));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetMetaDescriptionUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newMetaDescription = newProduct.getMetaDescription();
        LocalizedString oldMetaDescription = oldProduct.getMasterData().getStaged().getMetaDescription();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldMetaDescription, newMetaDescription, () -> SetMetaDescription.of((LocalizedString)newMetaDescription));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetMetaKeywordsUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newMetaKeywords = newProduct.getMetaKeywords();
        LocalizedString oldMetaKeywords = oldProduct.getMasterData().getStaged().getMetaKeywords();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldMetaKeywords, newMetaKeywords, () -> SetMetaKeywords.of((LocalizedString)newMetaKeywords));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetMetaTitleUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newMetaTitle = newProduct.getMetaTitle();
        LocalizedString oldMetaTitle = oldProduct.getMasterData().getStaged().getMetaTitle();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldMetaTitle, newMetaTitle, () -> SetMetaTitle.of((LocalizedString)newMetaTitle));
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildVariantsUpdateActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions, @Nonnull Map<String, AttributeMetaData> attributesMetaData) {
        if (ProductUpdateActionUtils.haveInvalidMasterVariants(oldProduct, newProduct, syncOptions)) {
            return Collections.emptyList();
        }
        ProductVariant oldMasterVariant = oldProduct.getMasterData().getStaged().getMasterVariant();
        List oldProductVariantsWithoutMaster = oldProduct.getMasterData().getStaged().getVariants();
        Map<String, ProductVariant> oldProductVariantsNoMaster = CollectionUtils.collectionToMap(oldProductVariantsWithoutMaster, ProductVariant::getKey);
        HashMap<String, ProductVariant> oldProductVariantsWithMaster = new HashMap<String, ProductVariant>(oldProductVariantsNoMaster);
        oldProductVariantsWithMaster.put(oldMasterVariant.getKey(), oldMasterVariant);
        ArrayList<ProductVariantDraft> newAllProductVariants = new ArrayList<ProductVariantDraft>(newProduct.getVariants());
        newAllProductVariants.add(newProduct.getMasterVariant());
        List<UpdateAction<Product>> updateActions = UnorderedCollectionSyncUtils.buildRemoveUpdateActions(oldProductVariantsWithoutMaster, newAllProductVariants, ProductVariant::getKey, ProductVariantDraft::getKey, variant -> RemoveVariant.ofVariantId((Integer)variant.getId(), (Boolean)true));
        CollectionUtils.emptyIfNull(newAllProductVariants).forEach(newProductVariant -> {
            if (newProductVariant == null) {
                ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, NULL_VARIANT, syncOptions);
            } else {
                String newProductVariantKey = newProductVariant.getKey();
                if (StringUtils.isBlank((CharSequence)newProductVariantKey)) {
                    ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_VARIANT_KEY, syncOptions);
                } else {
                    ProductVariant matchingOldVariant = (ProductVariant)oldProductVariantsWithMaster.get(newProductVariantKey);
                    List updateOrAddVariant = Optional.ofNullable(matchingOldVariant).map(oldVariant -> ProductUpdateActionUtils.collectAllVariantUpdateActions(ProductUpdateActionUtils.getSameForAllUpdateActions(updateActions), oldProduct, newProduct, oldVariant, newProductVariant, attributesMetaData, syncOptions)).orElseGet(() -> ProductUpdateActionUtils.buildAddVariantUpdateActionFromDraft(newProductVariant));
                    updateActions.addAll(updateOrAddVariant);
                }
            }
        });
        updateActions.addAll(ProductUpdateActionUtils.buildChangeMasterVariantUpdateAction(oldProduct, newProduct, syncOptions));
        return updateActions;
    }

    private static List<UpdateAction<Product>> getSameForAllUpdateActions(List<UpdateAction<Product>> updateActions) {
        return CollectionUtils.emptyIfNull(updateActions).stream().filter(productUpdateAction -> productUpdateAction instanceof SetAttributeInAllVariants).collect(Collectors.toList());
    }

    @Nonnull
    public static List<ProductVariantDraft> getAllVariants(@Nonnull ProductDraft productDraft) {
        ArrayList<ProductVariantDraft> allVariants = new ArrayList<ProductVariantDraft>(1 + productDraft.getVariants().size());
        allVariants.add(productDraft.getMasterVariant());
        allVariants.addAll(productDraft.getVariants());
        return allVariants;
    }

    private static boolean hasDuplicateSameForAllAction(List<UpdateAction<Product>> sameForAllUpdateActions, UpdateAction<Product> collectedUpdateAction) {
        return !(collectedUpdateAction instanceof SetAttributeInAllVariants) || ProductUpdateActionUtils.isSameForAllActionNew(sameForAllUpdateActions, collectedUpdateAction);
    }

    private static boolean isSameForAllActionNew(List<UpdateAction<Product>> sameForAllUpdateActions, UpdateAction<Product> productUpdateAction) {
        return sameForAllUpdateActions.stream().noneMatch(previouslyAddedAction -> previouslyAddedAction instanceof SetAttributeInAllVariants && previouslyAddedAction.getAction().equals(productUpdateAction.getAction()));
    }

    @Nonnull
    private static List<UpdateAction<Product>> collectAllVariantUpdateActions(@Nonnull List<UpdateAction<Product>> sameForAllUpdateActions, @Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull Map<String, AttributeMetaData> attributesMetaData, @Nonnull ProductSyncOptions syncOptions) {
        ArrayList<UpdateAction<Product>> updateActions = new ArrayList<UpdateAction<Product>>();
        SyncFilter syncFilter = syncOptions.getSyncFilter();
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.ATTRIBUTES, () -> CollectionUtils.emptyIfNull(ProductVariantUpdateActionUtils.buildProductVariantAttributesUpdateActions(oldProduct, newProduct, oldProductVariant, newProductVariant, attributesMetaData, syncOptions)).stream().filter(collectedUpdateAction -> ProductUpdateActionUtils.hasDuplicateSameForAllAction(sameForAllUpdateActions, (UpdateAction<Product>)collectedUpdateAction)).collect(Collectors.toList())));
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.IMAGES, () -> ProductVariantUpdateActionUtils.buildProductVariantImagesUpdateActions(oldProductVariant, newProductVariant)));
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.PRICES, () -> ProductVariantUpdateActionUtils.buildProductVariantPricesUpdateActions(oldProduct, newProduct, oldProductVariant, newProductVariant, syncOptions)));
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.ASSETS, () -> ProductVariantUpdateActionUtils.buildProductVariantAssetsUpdateActions(oldProduct, newProduct, oldProductVariant, newProductVariant, syncOptions)));
        ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SKU, () -> ProductVariantUpdateActionUtils.buildProductVariantSkuUpdateAction(oldProductVariant, newProductVariant)).ifPresent(updateActions::add);
        return updateActions;
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildPublishOrUnpublishUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, boolean hasNewUpdateActions) {
        boolean isNewProductPublished = BooleanUtils.toBoolean((Boolean)newProduct.isPublish());
        boolean isOldProductPublished = BooleanUtils.toBoolean((Boolean)oldProduct.getMasterData().isPublished());
        if (isNewProductPublished) {
            if (isOldProductPublished && (hasNewUpdateActions || oldProduct.getMasterData().hasStagedChanges().booleanValue())) {
                return Optional.of(Publish.of());
            }
            return CommonTypeUpdateActionUtils.buildUpdateAction(isOldProductPublished, true, Publish::of);
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(isOldProductPublished, false, Unpublish::of);
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildChangeMasterVariantUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions) {
        String newKey = newProduct.getMasterVariant().getKey();
        String oldKey = oldProduct.getMasterData().getStaged().getMasterVariant().getKey();
        if (ProductUpdateActionUtils.haveInvalidMasterVariants(oldProduct, newProduct, syncOptions)) {
            return Collections.emptyList();
        }
        return CommonTypeUpdateActionUtils.buildUpdateActions(newKey, oldKey, () -> {
            String newSku = newProduct.getMasterVariant().getSku();
            if (StringUtils.isBlank((CharSequence)newSku)) {
                ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_NEW_MASTER_VARIANT_SKU, syncOptions);
                return Collections.emptyList();
            }
            ArrayList<Object> updateActions = new ArrayList<Object>(2);
            updateActions.add(ChangeMasterVariant.ofSku((String)newSku, (Boolean)true));
            if (newProduct.getVariants().stream().noneMatch(variant -> Objects.equals(variant.getKey(), oldKey))) {
                updateActions.add(RemoveVariant.of((ProductVariant)oldProduct.getMasterData().getStaged().getMasterVariant()));
            }
            return updateActions;
        });
    }

    @Nonnull
    public static Optional<SetTaxCategory> buildSetTaxCategoryUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldProduct.getTaxCategory(), newProduct.getTaxCategory(), () -> SetTaxCategory.of((ResourceIdentifier)newProduct.getTaxCategory()));
    }

    @Nonnull
    public static Optional<TransitionState> buildTransitionStateUpdateAction(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        return Optional.ofNullable(newProduct.getState() != null && !Objects.equals(oldProduct.getState(), newProduct.getState()) ? TransitionState.of((Referenceable)newProduct.getState(), (Boolean)true) : null);
    }

    @Nonnull
    static List<UpdateAction<Product>> buildAddVariantUpdateActionFromDraft(@Nonnull ProductVariantDraft draft) {
        ArrayList<UpdateAction<Product>> actions = new ArrayList<UpdateAction<Product>>();
        AddVariant addVariant = AddVariant.of((List)draft.getAttributes(), (List)draft.getPrices(), (String)draft.getSku(), (Boolean)true).withKey(draft.getKey()).withImages(draft.getImages());
        actions.add((UpdateAction<Product>)addVariant);
        Optional.ofNullable(draft.getAssets()).map(assetDrafts -> assetDrafts.stream().map(assetDraft -> AddAsset.ofSku((String)draft.getSku(), (AssetDraft)assetDraft).withStaged(Boolean.valueOf(true))).collect(Collectors.toList())).ifPresent(actions::addAll);
        return actions;
    }

    @Nonnull
    static <T> Optional<T> buildActionIfPassesFilter(@Nonnull SyncFilter syncFilter, @Nonnull ActionGroup actionGroup, @Nonnull Supplier<Optional<T>> updateActionSupplier) {
        return FilterUtils.executeSupplierIfPassesFilter(syncFilter, actionGroup, updateActionSupplier, Optional::empty);
    }

    @Nonnull
    static <T> List<T> buildActionsIfPassesFilter(@Nonnull SyncFilter syncFilter, @Nonnull ActionGroup actionGroup, @Nonnull Supplier<List<T>> updateActionSupplier) {
        return FilterUtils.executeSupplierIfPassesFilter(syncFilter, actionGroup, updateActionSupplier, Collections::emptyList);
    }

    private static boolean haveInvalidMasterVariants(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions) {
        ProductVariantDraft newMasterVariant;
        boolean hasError = false;
        ProductVariant oldMasterVariant = oldProduct.getMasterData().getStaged().getMasterVariant();
        if (StringUtils.isBlank((CharSequence)oldMasterVariant.getKey())) {
            ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_OLD_MASTER_VARIANT_KEY, syncOptions);
            hasError = true;
        }
        if ((newMasterVariant = newProduct.getMasterVariant()) == null || StringUtils.isBlank((CharSequence)newMasterVariant.getKey())) {
            ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_NEW_MASTER_VARIANT_KEY, syncOptions);
            hasError = true;
        }
        return hasError;
    }

    private static void handleBuildVariantsUpdateActionsError(@Nonnull Product oldProduct, @Nonnull String reason, @Nonnull ProductSyncOptions syncOptions) {
        syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build variants update actions on the product with key '%s'. Reason: %s", oldProduct.getKey(), reason)), oldProduct, null, null);
    }

    private ProductUpdateActionUtils() {
    }
}

