/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.utils.AssetReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.sphere.sdk.customergroups.CustomerGroup;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.products.Price;
import io.sphere.sdk.products.PriceDraft;
import io.sphere.sdk.products.PriceDraftBuilder;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.ProductVariantDraftBuilder;
import io.sphere.sdk.products.attributes.Attribute;
import io.sphere.sdk.products.attributes.AttributeAccess;
import io.sphere.sdk.products.attributes.AttributeDraft;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class VariantReferenceResolutionUtils {
    @Nonnull
    public static List<ProductVariantDraft> mapToProductVariantDrafts(@Nonnull List<ProductVariant> productVariants) {
        return productVariants.stream().filter(Objects::nonNull).map(VariantReferenceResolutionUtils::mapToProductVariantDraft).collect(Collectors.toList());
    }

    @Nonnull
    private static ProductVariantDraft mapToProductVariantDraft(@Nonnull ProductVariant productVariant) {
        return ((ProductVariantDraftBuilder)((ProductVariantDraftBuilder)((ProductVariantDraftBuilder)ProductVariantDraftBuilder.of((ProductVariant)productVariant).prices(VariantReferenceResolutionUtils.mapToPriceDrafts(productVariant))).attributes(VariantReferenceResolutionUtils.replaceAttributesReferencesIdsWithKeys(productVariant))).assets(AssetReferenceResolutionUtils.mapToAssetDrafts(productVariant.getAssets()))).build();
    }

    @Nonnull
    static List<PriceDraft> mapToPriceDrafts(@Nonnull ProductVariant productVariant) {
        return productVariant.getPrices().stream().map(price -> PriceDraftBuilder.of((Price)price).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(price)).channel(SyncUtils.getResourceIdentifierWithKey(price.getChannel())).customerGroup(SyncUtils.getReferenceWithKeyReplaced(price.getCustomerGroup(), () -> CustomerGroup.referenceOfId((String)((CustomerGroup)price.getCustomerGroup().getObj()).getKey()))).build()).collect(Collectors.toList());
    }

    @Nonnull
    static List<AttributeDraft> replaceAttributesReferencesIdsWithKeys(@Nonnull ProductVariant productVariant) {
        return productVariant.getAttributes().stream().map(attribute -> VariantReferenceResolutionUtils.replaceAttributeReferenceIdWithKey(attribute).map(productReference -> AttributeDraft.of((String)attribute.getName(), (Object)productReference)).orElseGet(() -> VariantReferenceResolutionUtils.replaceAttributeReferenceSetIdsWithKeys(attribute).map(productReferenceSet -> AttributeDraft.of((String)attribute.getName(), (Object)productReferenceSet)).orElseGet(() -> AttributeDraft.of((String)attribute.getName(), (JsonNode)attribute.getValueAsJsonNode())))).collect(Collectors.toList());
    }

    static Optional<Reference<Product>> replaceAttributeReferenceIdWithKey(@Nonnull Attribute attribute) {
        return VariantReferenceResolutionUtils.getProductReference(attribute).map(productReference -> SyncUtils.getReferenceWithKeyReplaced(productReference, () -> Product.referenceOfId((String)((Product)productReference.getObj()).getKey())));
    }

    private static Optional<Reference<Product>> getProductReference(@Nonnull Attribute attribute) {
        return Optional.of(attribute).filter(VariantReferenceResolutionUtils::isProductReference).map(productReferenceAttribute -> (Reference)productReferenceAttribute.getValue(AttributeAccess.ofProductReference()));
    }

    static Optional<Set<Reference<Product>>> replaceAttributeReferenceSetIdsWithKeys(@Nonnull Attribute attribute) {
        return VariantReferenceResolutionUtils.getProductReferenceSet(attribute).map(productReferenceSet -> productReferenceSet.stream().map(productReference -> SyncUtils.getReferenceWithKeyReplaced(productReference, () -> Product.referenceOfId((String)((Product)productReference.getObj()).getKey()))).collect(Collectors.toSet()));
    }

    private static Optional<Set<Reference<Product>>> getProductReferenceSet(@Nonnull Attribute attribute) {
        return Optional.of(attribute).filter(VariantReferenceResolutionUtils::isProductReferenceSet).map(productReferenceSetAttribute -> (Set)productReferenceSetAttribute.getValue(AttributeAccess.ofProductReferenceSet()));
    }

    static boolean isProductReference(@Nonnull Attribute attribute) {
        JsonNode valueAsJsonNode = attribute.getValueAsJsonNode();
        return !(valueAsJsonNode instanceof ArrayNode) && VariantReferenceResolutionUtils.isValueAProductReference(valueAsJsonNode);
    }

    static boolean isProductReferenceSet(@Nonnull Attribute attribute) {
        Iterator setIterator;
        JsonNode valueAsJsonNode = attribute.getValueAsJsonNode();
        if (valueAsJsonNode instanceof ArrayNode && (setIterator = valueAsJsonNode.elements()).hasNext()) {
            return VariantReferenceResolutionUtils.isValueAProductReference((JsonNode)setIterator.next());
        }
        return false;
    }

    private static boolean isValueAProductReference(@Nonnull JsonNode valueAsJsonNode) {
        if (valueAsJsonNode.isContainerNode()) {
            JsonNode typeIdNode = valueAsJsonNode.get("typeId");
            return typeIdNode != null && Product.referenceTypeId().equals(typeIdNode.asText());
        }
        return false;
    }

    private VariantReferenceResolutionUtils() {
    }
}

