/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.EnumValuesUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedEnumValue;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.commands.updateactions.AddLocalizedEnumValue;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeLocalizedEnumValueLabel;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeLocalizedEnumValueOrder;
import io.sphere.sdk.producttypes.commands.updateactions.RemoveEnumValues;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LocalizedEnumValueUpdateActionUtils {
    @Nonnull
    public static List<UpdateAction<ProductType>> buildLocalizedEnumValuesUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull List<LocalizedEnumValue> oldEnumValues, @Nullable List<LocalizedEnumValue> newEnumValues) {
        return EnumValuesUpdateActionUtils.buildActions(attributeDefinitionName, oldEnumValues, newEnumValues, RemoveEnumValues::of, LocalizedEnumValueUpdateActionUtils::buildLocalizedEnumValueUpdateActions, AddLocalizedEnumValue::of, ChangeLocalizedEnumValueOrder::of, null);
    }

    @Nonnull
    public static List<UpdateAction<ProductType>> buildLocalizedEnumValueUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull LocalizedEnumValue oldEnumValue, @Nonnull LocalizedEnumValue newEnumValue) {
        return OptionalUtils.filterEmptyOptionals(LocalizedEnumValueUpdateActionUtils.buildChangeLabelAction(attributeDefinitionName, oldEnumValue, newEnumValue));
    }

    @Nonnull
    public static Optional<UpdateAction<ProductType>> buildChangeLabelAction(@Nonnull String attributeDefinitionName, @Nonnull LocalizedEnumValue oldEnumValue, @Nonnull LocalizedEnumValue newEnumValue) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldEnumValue.getLabel(), newEnumValue.getLabel(), () -> ChangeLocalizedEnumValueLabel.of((String)attributeDefinitionName, (LocalizedEnumValue)newEnumValue));
    }

    private LocalizedEnumValueUpdateActionUtils() {
    }
}

