/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.producttypes.utils.AttributeDefinitionsUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeDescription;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeName;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ProductTypeUpdateActionUtils {
    @Nonnull
    public static Optional<UpdateAction<ProductType>> buildChangeNameAction(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldProductType.getName(), newProductType.getName(), () -> ChangeName.of((String)newProductType.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<ProductType>> buildChangeDescriptionAction(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldProductType.getDescription(), newProductType.getDescription(), () -> ChangeDescription.of((String)newProductType.getDescription()));
    }

    @Nonnull
    public static List<UpdateAction<ProductType>> buildAttributesUpdateActions(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType, @Nonnull ProductTypeSyncOptions syncOptions) {
        try {
            return AttributeDefinitionsUpdateActionUtils.buildAttributeDefinitionsUpdateActions(oldProductType.getAttributes(), newProductType.getAttributes());
        }
        catch (BuildUpdateActionException exception) {
            syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build update actions for the attributes definitions of the product type with the key '%s'. Reason: %s", oldProductType.getKey(), exception), exception), oldProductType, newProductType, null);
            return Collections.emptyList();
        }
    }

    private ProductTypeUpdateActionUtils() {
    }
}

