/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.commands.CategoryCreateCommand;
import io.sphere.sdk.categories.commands.CategoryUpdateCommand;
import io.sphere.sdk.categories.expansion.CategoryExpansionModel;
import io.sphere.sdk.categories.queries.CategoryQuery;
import io.sphere.sdk.categories.queries.CategoryQueryBuilder;
import io.sphere.sdk.categories.queries.CategoryQueryModel;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.queries.QueryPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CategoryServiceImpl
extends BaseServiceWithKey<CategoryDraft, Category, CategorySyncOptions, CategoryQuery, CategoryQueryModel, CategoryExpansionModel<Category>>
implements CategoryService {
    public CategoryServiceImpl(@Nonnull CategorySyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> categoryKeys) {
        return this.cacheKeysToIds(categoryKeys, keysNotCached -> CategoryQuery.of().withPredicates(this.buildCategoryKeysQueryPredicate((Set<String>)keysNotCached)));
    }

    QueryPredicate<Category> buildCategoryKeysQueryPredicate(@Nonnull Set<String> categoryKeys) {
        String keysQueryString = categoryKeys.stream().filter(StringUtils::isNotBlank).map(productKey -> String.format("\"%s\"", productKey)).collect(Collectors.joining(","));
        return QueryPredicate.of((String)String.format("key in (%s)", keysQueryString));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Category>> fetchMatchingCategoriesByKeys(@Nonnull Set<String> categoryKeys) {
        return this.fetchMatchingResources(categoryKeys, () -> CategoryQuery.of().plusPredicates(categoryQueryModel -> categoryQueryModel.key().isIn((Iterable)categoryKeys)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Category>> fetchCategory(@Nullable String key) {
        return this.fetchResource(key, () -> CategoryQuery.of().plusPredicates(categoryQueryModel -> categoryQueryModel.key().is(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCategoryId(@Nonnull String key) {
        return this.fetchCachedResourceId(key, () -> CategoryQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn(Collections.singleton(key))).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Category>> createCategory(@Nonnull CategoryDraft categoryDraft) {
        return this.createResource(categoryDraft, CategoryCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<Category> updateCategory(@Nonnull Category category, @Nonnull List<UpdateAction<Category>> updateActions) {
        return this.updateResource(category, CategoryUpdateCommand::of, updateActions);
    }
}

