/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.utils;

import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.DuplicateKeyException;
import com.commercetools.sync.commons.exceptions.DuplicateNameException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.types.utils.FieldDefinitionUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.TextInputHint;
import io.sphere.sdk.types.FieldDefinition;
import io.sphere.sdk.types.FieldType;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.types.commands.updateactions.AddFieldDefinition;
import io.sphere.sdk.types.commands.updateactions.ChangeFieldDefinitionOrder;
import io.sphere.sdk.types.commands.updateactions.RemoveFieldDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class FieldDefinitionsUpdateActionUtils {
    @Nonnull
    static List<UpdateAction<Type>> buildFieldDefinitionsUpdateActions(@Nonnull List<FieldDefinition> oldFieldDefinitions, @Nullable List<FieldDefinition> newFieldDefinitions) throws BuildUpdateActionException {
        if (newFieldDefinitions != null) {
            return FieldDefinitionsUpdateActionUtils.buildUpdateActions(oldFieldDefinitions, newFieldDefinitions.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return oldFieldDefinitions.stream().map(FieldDefinition::getName).map(RemoveFieldDefinition::of).collect(Collectors.toList());
    }

    @Nonnull
    private static List<UpdateAction<Type>> buildUpdateActions(@Nonnull List<FieldDefinition> oldFieldDefinitions, @Nonnull List<FieldDefinition> newFieldDefinitions) throws BuildUpdateActionException {
        try {
            List<UpdateAction<Type>> updateActions = FieldDefinitionsUpdateActionUtils.buildRemoveFieldDefinitionOrFieldDefinitionUpdateActions(oldFieldDefinitions, newFieldDefinitions);
            updateActions.addAll(FieldDefinitionsUpdateActionUtils.buildAddFieldDefinitionUpdateActions(oldFieldDefinitions, newFieldDefinitions));
            FieldDefinitionsUpdateActionUtils.buildChangeFieldDefinitionOrderUpdateAction(oldFieldDefinitions, newFieldDefinitions).ifPresent(updateActions::add);
            return updateActions;
        }
        catch (DuplicateKeyException | DuplicateNameException exception) {
            throw new BuildUpdateActionException(exception);
        }
    }

    @Nonnull
    private static List<UpdateAction<Type>> buildRemoveFieldDefinitionOrFieldDefinitionUpdateActions(@Nonnull List<FieldDefinition> oldFieldDefinitions, @Nonnull List<FieldDefinition> newFieldDefinitions) {
        Map<String, FieldDefinition> newFieldDefinitionsNameMap = newFieldDefinitions.stream().collect(Collectors.toMap(FieldDefinition::getName, fieldDefinition -> fieldDefinition, (fieldDefinitionA, fieldDefinitionB) -> {
            throw new DuplicateNameException(String.format("Field definitions have duplicated names. Duplicated field definition name: '%s'. Field definitions names are expected to be unique inside their type.", fieldDefinitionA.getName()));
        }));
        return oldFieldDefinitions.stream().map(oldFieldDefinition -> {
            String oldFieldDefinitionName = oldFieldDefinition.getName();
            FieldDefinition matchingNewFieldDefinition = (FieldDefinition)newFieldDefinitionsNameMap.get(oldFieldDefinitionName);
            return Optional.ofNullable(matchingNewFieldDefinition).map(newFieldDefinition -> {
                if (newFieldDefinition.getType() != null) {
                    if (FieldDefinitionsUpdateActionUtils.haveSameFieldType(oldFieldDefinition.getType(), newFieldDefinition.getType())) {
                        return FieldDefinitionUpdateActionUtils.buildActions(oldFieldDefinition, newFieldDefinition);
                    }
                    return Arrays.asList(RemoveFieldDefinition.of((String)oldFieldDefinitionName), AddFieldDefinition.of((FieldDefinition)newFieldDefinition));
                }
                return new ArrayList();
            }).orElseGet(() -> Collections.singletonList(RemoveFieldDefinition.of((String)oldFieldDefinitionName)));
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean haveSameFieldType(@Nonnull FieldType fieldTypeA, @Nonnull FieldType fieldTypeB) {
        return fieldTypeA.getClass() == fieldTypeB.getClass();
    }

    @Nonnull
    private static Optional<UpdateAction<Type>> buildChangeFieldDefinitionOrderUpdateAction(@Nonnull List<FieldDefinition> oldFieldDefinitions, @Nonnull List<FieldDefinition> newFieldDefinitions) {
        List newNames = newFieldDefinitions.stream().map(FieldDefinition::getName).collect(Collectors.toList());
        List existingNames = oldFieldDefinitions.stream().map(FieldDefinition::getName).filter(newNames::contains).collect(Collectors.toList());
        List notExistingNames = newNames.stream().filter(newName -> !existingNames.contains(newName)).collect(Collectors.toList());
        List newFieldDefinitionsOrderNames = newFieldDefinitions.stream().map(FieldDefinition::getName).collect(Collectors.toList());
        List allNames = Stream.concat(existingNames.stream(), notExistingNames.stream()).collect(Collectors.toList());
        return CommonTypeUpdateActionUtils.buildUpdateAction(allNames, newNames, () -> ChangeFieldDefinitionOrder.of((List)newFieldDefinitionsOrderNames));
    }

    @Nonnull
    private static List<UpdateAction<Type>> buildAddFieldDefinitionUpdateActions(@Nonnull List<FieldDefinition> oldFieldDefinitions, @Nonnull List<FieldDefinition> newFieldDefinitions) {
        Map<String, FieldDefinition> oldFieldDefinitionsNameMap = oldFieldDefinitions.stream().collect(Collectors.toMap(FieldDefinition::getName, fieldDefinition -> fieldDefinition));
        return newFieldDefinitions.stream().filter(fieldDefinition -> !oldFieldDefinitionsNameMap.containsKey(fieldDefinition.getName())).map(fieldDefinition -> FieldDefinition.of((FieldType)fieldDefinition.getType(), (String)fieldDefinition.getName(), (LocalizedString)fieldDefinition.getLabel(), (Boolean)fieldDefinition.isRequired(), (TextInputHint)fieldDefinition.getInputHint())).map(AddFieldDefinition::of).collect(Collectors.toList());
    }

    private FieldDefinitionsUpdateActionUtils() {
    }
}

