/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.services.TypeService;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.models.Builder;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.types.CustomFieldsDraft;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class CustomReferenceResolver<D, B extends Builder<? extends D>, S extends BaseSyncOptions>
extends BaseReferenceResolver<D, S> {
    public static final String TYPE_DOES_NOT_EXIST = "Type with key '%s' doesn't exist.";
    private final TypeService typeService;

    protected CustomReferenceResolver(@Nonnull S options, @Nonnull TypeService typeService) {
        super(options);
        this.typeService = typeService;
    }

    protected abstract CompletionStage<B> resolveCustomTypeReference(@Nonnull B var1);

    @Nonnull
    protected CompletionStage<B> resolveCustomTypeReference(@Nonnull B draftBuilder, @Nonnull Function<B, CustomFieldsDraft> customGetter, @Nonnull BiFunction<B, CustomFieldsDraft, B> customSetter, @Nonnull String errorMessage) {
        ResourceIdentifier customType;
        CustomFieldsDraft custom = customGetter.apply(draftBuilder);
        if (custom != null && (customType = custom.getType()).getId() == null) {
            String customTypeKey;
            try {
                customTypeKey = this.getCustomTypeKey((ResourceIdentifier<Type>)customType, errorMessage);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
            }
            return this.fetchAndResolveTypeReference(draftBuilder, customSetter, custom.getFields(), customTypeKey, errorMessage);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    private String getCustomTypeKey(@Nonnull ResourceIdentifier<Type> customType, @Nonnull String referenceResolutionErrorMessage) throws ReferenceResolutionException {
        try {
            return CustomReferenceResolver.getKeyFromResourceIdentifier(customType);
        }
        catch (ReferenceResolutionException exception) {
            String errorMessage = String.format("%s Reason: %s", referenceResolutionErrorMessage, exception.getMessage());
            throw new ReferenceResolutionException(errorMessage, exception);
        }
    }

    @Nonnull
    private CompletionStage<B> fetchAndResolveTypeReference(@Nonnull B draftBuilder, @Nonnull BiFunction<B, CustomFieldsDraft, B> customSetter, @Nullable Map<String, JsonNode> customFields, @Nonnull String typeKey, @Nonnull String referenceResolutionErrorMessage) {
        return this.typeService.fetchCachedTypeId(typeKey).thenCompose(resolvedTypeIdOptional -> resolvedTypeIdOptional.map(resolvedTypeId -> CompletableFuture.completedFuture(customSetter.apply(draftBuilder, CustomFieldsDraft.ofTypeIdAndJson((String)resolvedTypeId, (Map)customFields)))).orElseGet(() -> {
            String errorMessage = String.format("%s Reason: %s", referenceResolutionErrorMessage, String.format(TYPE_DOES_NOT_EXIST, typeKey));
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(errorMessage));
        }));
    }
}

