/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.models.ResourceKeyIdGraphQlResult;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.client.HttpRequestIntent;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.http.HttpMethod;
import io.sphere.sdk.http.HttpResponse;
import io.sphere.sdk.json.SphereJsonUtils;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ResourceKeyIdGraphQlRequest
implements SphereRequest<ResourceKeyIdGraphQlResult> {
    protected final Set<String> keysToSearch;
    protected final GraphQlQueryResources resource;
    private long limit = 500L;
    private String queryPredicate = null;

    public ResourceKeyIdGraphQlRequest(@Nonnull Set<String> keysToSearch, @Nonnull GraphQlQueryResources resource) {
        this.keysToSearch = Objects.requireNonNull(keysToSearch);
        this.resource = resource;
    }

    @Nonnull
    public ResourceKeyIdGraphQlRequest withPredicate(String predicate) {
        this.queryPredicate = predicate;
        return this;
    }

    @Nonnull
    public ResourceKeyIdGraphQlRequest withLimit(long limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    public ResourceKeyIdGraphQlResult deserialize(HttpResponse httpResponse) {
        JsonNode rootJsonNode = SphereJsonUtils.parse((byte[])httpResponse.getResponseBody());
        if (rootJsonNode.isNull()) {
            return null;
        }
        JsonNode result = rootJsonNode.get("data").get(this.resource.getName());
        return (ResourceKeyIdGraphQlResult)SphereJsonUtils.readObject((JsonNode)result, ResourceKeyIdGraphQlResult.class);
    }

    public HttpRequestIntent httpRequestIntent() {
        String body = String.format("{\"query\": \"{%s}\"}", this.buildQueryString());
        return HttpRequestIntent.of((HttpMethod)HttpMethod.POST, (String)"/graphql", (String)body);
    }

    @Nonnull
    String buildQueryString() {
        return String.format("%s(limit: %d, where: \\\"%s\\\", sort: [\\\"id asc\\\"]) { results { id key } }", this.resource.getName(), this.limit, this.createWhereQuery(this.keysToSearch));
    }

    @Nonnull
    private String createWhereQuery(@Nonnull Set<String> keys) {
        String backslashQuote = "\\\\\\\"";
        String commaSeparatedKeys = keys.stream().filter(key -> !StringUtils.isBlank((CharSequence)key)).collect(Collectors.joining(String.format("%s, %s", "\\\\\\\"", "\\\\\\\""), "\\\\\\\"", "\\\\\\\""));
        String whereQuery = ResourceKeyIdGraphQlRequest.createWhereQuery(commaSeparatedKeys);
        return StringUtils.isBlank((CharSequence)this.queryPredicate) ? whereQuery : String.format("%s AND %s", whereQuery, this.queryPredicate);
    }

    @Nonnull
    private static String createWhereQuery(@Nonnull String commaSeparatedKeys) {
        return String.format("key in (%s)", commaSeparatedKeys);
    }
}

