/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.ResourceKeyId;
import com.commercetools.sync.commons.utils.GraphQlQueryAll;
import com.commercetools.sync.commons.utils.QueryAll;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.models.ResourceView;
import io.sphere.sdk.queries.QueryDsl;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class CtpQueryUtils {
    @Nonnull
    public static <T extends ResourceView, C extends QueryDsl<T, C>, S> CompletionStage<List<S>> queryAll(@Nonnull SphereClient client, @Nonnull QueryDsl<T, C> query, @Nonnull Function<List<T>, S> pageMapper) {
        return CtpQueryUtils.queryAll(client, query, pageMapper, 500);
    }

    @Nonnull
    public static <T extends ResourceView, C extends QueryDsl<T, C>> CompletionStage<Void> queryAll(@Nonnull SphereClient client, @Nonnull QueryDsl<T, C> query, @Nonnull Consumer<List<T>> pageConsumer) {
        return CtpQueryUtils.queryAll(client, query, pageConsumer, 500);
    }

    @Nonnull
    public static <T extends ResourceView, C extends QueryDsl<T, C>, S> CompletionStage<List<S>> queryAll(@Nonnull SphereClient client, @Nonnull QueryDsl<T, C> query, @Nonnull Function<List<T>, S> pageMapper, int pageSize) {
        QueryAll<T, C, S> queryAll = QueryAll.of(client, query, pageSize);
        return queryAll.run(pageMapper);
    }

    @Nonnull
    public static <T extends ResourceView, C extends QueryDsl<T, C>> CompletionStage<Void> queryAll(@Nonnull SphereClient client, @Nonnull QueryDsl<T, C> query, @Nonnull Consumer<List<T>> pageConsumer, int pageSize) {
        QueryAll queryAll = QueryAll.of(client, query, pageSize);
        return queryAll.run(pageConsumer);
    }

    @Nonnull
    public static CompletionStage<Void> queryAll(@Nonnull SphereClient client, @Nonnull ResourceKeyIdGraphQlRequest resourceKeyIdGraphQlRequest, @Nonnull Consumer<Set<ResourceKeyId>> pageConsumer) {
        GraphQlQueryAll graphQlQueryAll = GraphQlQueryAll.of(client, resourceKeyIdGraphQlRequest, 500);
        return graphQlQueryAll.run(pageConsumer);
    }

    private CtpQueryUtils() {
    }
}

