/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.ResourceKeyId;
import com.commercetools.sync.commons.models.ResourceKeyIdGraphQlResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereRequest;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

final class GraphQlQueryAll {
    private final SphereClient client;
    private final ResourceKeyIdGraphQlRequest resourceKeyIdGraphQlRequest;
    private final long pageSize;
    private Consumer<Set<ResourceKeyId>> pageConsumer;

    private GraphQlQueryAll(@Nonnull SphereClient client, @Nonnull ResourceKeyIdGraphQlRequest resourceKeyIdGraphQlRequest, long pageSize) {
        this.client = client;
        this.resourceKeyIdGraphQlRequest = GraphQlQueryAll.withDefaults(resourceKeyIdGraphQlRequest, pageSize);
        this.pageSize = pageSize;
    }

    @Nonnull
    private static ResourceKeyIdGraphQlRequest withDefaults(@Nonnull ResourceKeyIdGraphQlRequest resourceKeyIdGraphQlRequest, long pageSize) {
        return resourceKeyIdGraphQlRequest.withLimit(pageSize);
    }

    @Nonnull
    static GraphQlQueryAll of(@Nonnull SphereClient client, @Nonnull ResourceKeyIdGraphQlRequest resourceKeyIdGraphQlRequest, int pageSize) {
        return new GraphQlQueryAll(client, resourceKeyIdGraphQlRequest, pageSize);
    }

    @Nonnull
    CompletionStage<Void> run(@Nonnull Consumer<Set<ResourceKeyId>> pageConsumer) {
        this.pageConsumer = pageConsumer;
        CompletionStage firstPage = this.client.execute((SphereRequest)this.resourceKeyIdGraphQlRequest);
        return this.queryNextPages(firstPage);
    }

    @Nonnull
    private CompletionStage<Void> queryNextPages(@Nonnull CompletionStage<ResourceKeyIdGraphQlResult> currentPageStage) {
        return currentPageStage.thenCompose(currentPage -> currentPage != null ? this.queryNextPages(this.processPageAndGetNext((ResourceKeyIdGraphQlResult)currentPage)) : CompletableFuture.completedFuture(null));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<ResourceKeyIdGraphQlResult> processPageAndGetNext(@Nonnull ResourceKeyIdGraphQlResult page) {
        Set<ResourceKeyId> currentPageElements = page.getResults();
        if (!currentPageElements.isEmpty()) {
            this.consumePageElements(currentPageElements);
            return this.getNextPageStage(currentPageElements);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void consumePageElements(@Nonnull Set<ResourceKeyId> pageElements) {
        this.pageConsumer.accept(pageElements);
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<ResourceKeyIdGraphQlResult> getNextPageStage(@Nonnull Set<ResourceKeyId> pageElements) {
        if ((long)pageElements.size() == this.pageSize) {
            String lastElementId = "";
            Iterator<ResourceKeyId> iterator = pageElements.iterator();
            while (iterator.hasNext()) {
                lastElementId = iterator.next().getId();
            }
            String queryPredicate = StringUtils.isBlank((CharSequence)lastElementId) ? null : String.format("id > \\\\\\\"%s\\\\\\\"", lastElementId);
            return this.client.execute((SphereRequest)this.resourceKeyIdGraphQlRequest.withPredicate(queryPredicate));
        }
        return CompletableFuture.completedFuture(null);
    }
}

