/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.sync.commons.helpers.AssetActionFactory;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.utils.ProductVariantAssetUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.commands.updateactions.AddAsset;
import io.sphere.sdk.products.commands.updateactions.ChangeAssetOrder;
import io.sphere.sdk.products.commands.updateactions.RemoveAsset;
import java.util.List;
import javax.annotation.Nonnull;

public final class ProductAssetActionFactory
extends AssetActionFactory<Product, ProductDraft> {
    private Integer variantId;

    public ProductAssetActionFactory(@Nonnull Integer variantId, @Nonnull ProductSyncOptions syncOptions) {
        this.variantId = variantId;
        this.syncOptions = syncOptions;
    }

    @Override
    public List<UpdateAction<Product>> buildAssetActions(@Nonnull Product oldResource, @Nonnull ProductDraft newResource, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAssetDraft) {
        return ProductVariantAssetUpdateActionUtils.buildActions((Resource)oldResource, newResource, this.variantId, oldAsset, newAssetDraft, (ProductSyncOptions)this.syncOptions);
    }

    @Override
    public UpdateAction<Product> buildRemoveAssetAction(@Nonnull String assetKey) {
        return RemoveAsset.ofVariantIdWithKey((Integer)this.variantId, (String)assetKey, (Boolean)true);
    }

    @Override
    public UpdateAction<Product> buildChangeAssetOrderAction(@Nonnull List<String> newAssetOrder) {
        return ChangeAssetOrder.ofVariantId((Integer)this.variantId, newAssetOrder, (Boolean)true);
    }

    @Override
    public UpdateAction<Product> buildAddAssetAction(@Nonnull AssetDraft assetDraft, @Nonnull Integer position) {
        return AddAsset.ofVariantId((Integer)this.variantId, (AssetDraft)assetDraft).withPosition(position).withStaged(Boolean.valueOf(true));
    }
}

