/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.services.impl.BaseService;
import io.sphere.sdk.commands.DraftBasedCreateCommand;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.models.WithKey;
import io.sphere.sdk.queries.MetaModelQueryDsl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class BaseServiceWithKey<T extends WithKey, U extends Resource<U> & WithKey, S extends BaseSyncOptions, Q extends MetaModelQueryDsl<U, Q, M, E>, M, E>
extends BaseService<T, U, S, Q, M, E> {
    BaseServiceWithKey(@Nonnull S syncOptions) {
        super(syncOptions);
    }

    @Nonnull
    CompletionStage<Optional<U>> createResource(@Nonnull T draft, @Nonnull Function<T, DraftBasedCreateCommand<U, T>> createCommand) {
        return super.createResource(draft, WithKey::getKey, createCommand);
    }

    @Nonnull
    CompletionStage<Optional<String>> fetchCachedResourceId(@Nullable String key, @Nonnull Supplier<Q> querySupplier) {
        return super.fetchCachedResourceId(key, resource -> ((WithKey)resource).getKey(), querySupplier);
    }

    @Nonnull
    CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> keys, @Nonnull Function<Set<String>, ResourceKeyIdGraphQlRequest> keysRequestMapper) {
        return super.cacheKeysToIdsUsingGraphQl(keys, resource -> Collections.singletonMap(resource.getKey(), resource.getId()), keysRequestMapper);
    }

    @Nonnull
    CompletionStage<Set<U>> fetchMatchingResources(@Nonnull Set<String> keys, @Nonnull Supplier<Q> querySupplier) {
        return super.fetchMatchingResources(keys, resource -> ((WithKey)resource).getKey(), querySupplier);
    }
}

