/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.customobjects.CustomObjectSyncOptions;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.services.CustomObjectService;
import com.commercetools.sync.services.impl.BaseService;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.DraftBasedCreateCommand;
import io.sphere.sdk.customobjects.CustomObject;
import io.sphere.sdk.customobjects.CustomObjectDraft;
import io.sphere.sdk.customobjects.commands.CustomObjectUpsertCommand;
import io.sphere.sdk.customobjects.expansion.CustomObjectExpansionModel;
import io.sphere.sdk.customobjects.queries.CustomObjectQuery;
import io.sphere.sdk.customobjects.queries.CustomObjectQueryBuilder;
import io.sphere.sdk.customobjects.queries.CustomObjectQueryModel;
import io.sphere.sdk.queries.QueryPredicate;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CustomObjectServiceImpl
extends BaseService<CustomObjectDraft<JsonNode>, CustomObject<JsonNode>, CustomObjectSyncOptions, CustomObjectQuery<JsonNode>, CustomObjectQueryModel<CustomObject<JsonNode>>, CustomObjectExpansionModel<CustomObject<JsonNode>>>
implements CustomObjectService {
    public CustomObjectServiceImpl(@Nonnull CustomObjectSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        return this.cacheKeysToIds(this.getKeys(identifiers), this::keyMapper, keysNotCached -> this.queryIdentifiers(this.getIdentifiers((Set<String>)keysNotCached)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCustomObjectId(@Nonnull CustomObjectCompositeIdentifier identifier) {
        return this.fetchCachedResourceId(identifier.toString(), this::keyMapper, () -> this.queryOneIdentifier(identifier));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<CustomObject<JsonNode>>> fetchMatchingCustomObjects(@Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        return this.fetchMatchingResources(this.getKeys(identifiers), this::keyMapper, () -> this.queryIdentifiers(identifiers));
    }

    @Nonnull
    private QueryPredicate<CustomObject<JsonNode>> createQuery(@Nonnull CustomObjectQueryModel<CustomObject<JsonNode>> queryModel, @Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        QueryPredicate queryPredicate = QueryPredicate.of(null);
        boolean firstAttempt = true;
        for (CustomObjectCompositeIdentifier identifier : identifiers) {
            String key = identifier.getKey();
            String container = identifier.getContainer();
            if (firstAttempt) {
                queryPredicate = queryModel.container().is(container).and(queryModel.key().is(key));
                firstAttempt = false;
                continue;
            }
            queryPredicate = queryPredicate.or(queryModel.container().is(container).and(queryModel.key().is(key)));
        }
        return queryPredicate;
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CustomObject<JsonNode>>> fetchCustomObject(@Nonnull CustomObjectCompositeIdentifier identifier) {
        return this.fetchResource(identifier.toString(), () -> this.queryOneIdentifier(identifier));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CustomObject<JsonNode>>> upsertCustomObject(@Nonnull CustomObjectDraft<JsonNode> customObjectDraft) {
        return this.createResource(customObjectDraft, this::keyMapper, CustomObjectUpsertCommand::of);
    }

    @Override
    @Nonnull
    CompletionStage<Optional<CustomObject<JsonNode>>> executeCreateCommand(@Nonnull CustomObjectDraft<JsonNode> draft, @Nonnull Function<CustomObjectDraft<JsonNode>, String> keyMapper, @Nonnull Function<CustomObjectDraft<JsonNode>, DraftBasedCreateCommand<CustomObject<JsonNode>, CustomObjectDraft<JsonNode>>> createCommand) {
        String draftKey = keyMapper.apply(draft);
        return ((CustomObjectSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)createCommand.apply(draft)).thenApply(resource -> {
            this.keyToIdCache.put((Object)draftKey, (Object)resource.getId());
            return Optional.of(resource);
        });
    }

    @Nonnull
    private Set<String> getKeys(@Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        return identifiers.stream().map(CustomObjectCompositeIdentifier::toString).collect(Collectors.toSet());
    }

    @Nonnull
    private String keyMapper(@Nonnull CustomObjectDraft<JsonNode> customObjectDraft) {
        return CustomObjectCompositeIdentifier.of(customObjectDraft).toString();
    }

    @Nonnull
    private String keyMapper(@Nonnull CustomObject<JsonNode> customObject) {
        return CustomObjectCompositeIdentifier.of(customObject).toString();
    }

    @Nonnull
    private Set<CustomObjectCompositeIdentifier> getIdentifiers(@Nonnull Set<String> keys) {
        return keys.stream().map(CustomObjectCompositeIdentifier::of).collect(Collectors.toSet());
    }

    @Nonnull
    private CustomObjectQuery<JsonNode> queryIdentifiers(@Nonnull Set<CustomObjectCompositeIdentifier> identifiers) {
        return CustomObjectQueryBuilder.ofJsonNode().plusPredicates(q -> this.createQuery((CustomObjectQueryModel<CustomObject<JsonNode>>)q, identifiers)).build();
    }

    @Nonnull
    private CustomObjectQuery<JsonNode> queryOneIdentifier(@Nonnull CustomObjectCompositeIdentifier identifier) {
        return CustomObjectQueryBuilder.ofJsonNode().plusPredicates(q -> q.container().is(identifier.getContainer()).and(q.key().is(identifier.getKey()))).build();
    }
}

