/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.customers.CustomerDraft;
import io.sphere.sdk.customers.commands.CustomerCreateCommand;
import io.sphere.sdk.customers.commands.CustomerUpdateCommand;
import io.sphere.sdk.customers.expansion.CustomerExpansionModel;
import io.sphere.sdk.customers.queries.CustomerQuery;
import io.sphere.sdk.customers.queries.CustomerQueryBuilder;
import io.sphere.sdk.customers.queries.CustomerQueryModel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomerServiceImpl
extends BaseServiceWithKey<CustomerDraft, Customer, CustomerSyncOptions, CustomerQuery, CustomerQueryModel, CustomerExpansionModel<Customer>>
implements CustomerService {
    public CustomerServiceImpl(@Nonnull CustomerSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> keysToCache) {
        return this.cacheKeysToIds(keysToCache, keysNotCached -> new ResourceKeyIdGraphQlRequest((Set<String>)keysNotCached, GraphQlQueryResources.CUSTOMERS));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Customer>> fetchMatchingCustomersByKeys(@Nonnull Set<String> customerKeys) {
        return this.fetchMatchingResources(customerKeys, () -> CustomerQueryBuilder.of().plusPredicates(customerQueryModel -> customerQueryModel.key().isIn((Iterable)customerKeys)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Customer>> fetchCustomerByKey(@Nullable String key) {
        return this.fetchResource(key, () -> CustomerQueryBuilder.of().plusPredicates(customerQueryModel -> customerQueryModel.key().is(key)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCustomerId(@Nonnull String key) {
        return this.fetchCachedResourceId(key, () -> CustomerQueryBuilder.of().plusPredicates(customerQueryModel -> customerQueryModel.key().is(key)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Customer>> createCustomer(@Nonnull CustomerDraft customerDraft) {
        String draftKey = customerDraft.getKey();
        CustomerCreateCommand createCommand = CustomerCreateCommand.of((CustomerDraft)customerDraft);
        if (StringUtils.isBlank((CharSequence)draftKey)) {
            ((CustomerSyncOptions)this.syncOptions).applyErrorCallback(new SyncException(String.format("Failed to create draft with key: '%s'. Reason: %s", draftKey, "Draft key is blank!")), null, customerDraft, null);
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return ((CustomerSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)createCommand).handle((resource, exception) -> {
            if (exception == null && resource.getCustomer() != null) {
                this.keyToIdCache.put((Object)draftKey, (Object)resource.getCustomer().getId());
                return Optional.of(resource.getCustomer());
            }
            if (exception != null) {
                ((CustomerSyncOptions)this.syncOptions).applyErrorCallback(new SyncException(String.format("Failed to create draft with key: '%s'. Reason: %s", draftKey, exception.getMessage()), (Throwable)exception), null, customerDraft, null);
                return Optional.empty();
            }
            return Optional.empty();
        });
    }

    @Override
    @Nonnull
    public CompletionStage<Customer> updateCustomer(@Nonnull Customer customer, @Nonnull List<UpdateAction<Customer>> updateActions) {
        return this.updateResource(customer, CustomerUpdateCommand::of, updateActions);
    }
}

