/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import com.commercetools.sync.states.StateSyncOptions;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import io.sphere.sdk.states.commands.StateCreateCommand;
import io.sphere.sdk.states.commands.StateUpdateCommand;
import io.sphere.sdk.states.expansion.StateExpansionModel;
import io.sphere.sdk.states.queries.StateQuery;
import io.sphere.sdk.states.queries.StateQueryBuilder;
import io.sphere.sdk.states.queries.StateQueryModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StateServiceImpl
extends BaseServiceWithKey<StateDraft, State, StateSyncOptions, StateQuery, StateQueryModel, StateExpansionModel<State>>
implements StateService {
    private static final String STATE_KEY_NOT_SET = "State with id: '%s' has no key set. Keys are required for state matching.";

    public StateServiceImpl(@Nonnull StateSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> keys) {
        return this.cacheKeysToIds(keys, keysNotCached -> new ResourceKeyIdGraphQlRequest((Set<String>)keysNotCached, GraphQlQueryResources.STATES));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedStateId(@Nullable String key) {
        return this.fetchCachedResourceId(key, () -> StateQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn(Collections.singleton(key))).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Set<State>> fetchMatchingStatesByKeys(@Nonnull Set<String> stateKeys) {
        return this.fetchMatchingStates(stateKeys, false);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<State>> fetchMatchingStatesByKeysWithTransitions(@Nonnull Set<String> stateKeys) {
        return this.fetchMatchingStates(stateKeys, true);
    }

    private CompletionStage<Set<State>> fetchMatchingStates(@Nonnull Set<String> stateKeys, boolean withTransitions) {
        return this.fetchMatchingResources(stateKeys, () -> {
            StateQuery stateQuery = StateQuery.of().plusPredicates(stateQueryModel -> stateQueryModel.key().isIn((Iterable)stateKeys));
            if (withTransitions) {
                stateQuery = stateQuery.withExpansionPaths(StateExpansionModel::transitions);
            }
            return stateQuery;
        });
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<State>> fetchState(@Nullable String key) {
        return this.fetchResource(key, () -> StateQuery.of().plusPredicates(stateQueryModel -> stateQueryModel.key().is(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<State>> createState(@Nonnull StateDraft stateDraft) {
        return this.createResource(stateDraft, StateCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<State> updateState(@Nonnull State state, @Nonnull List<UpdateAction<State>> updateActions) {
        return this.updateResource(state, StateUpdateCommand::of, updateActions);
    }
}

