/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.customers.CustomerSyncOptionsBuilder;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.ShoppingListService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.CustomerServiceImpl;
import com.commercetools.sync.services.impl.ShoppingListServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.helpers.ShoppingListBatchValidator;
import com.commercetools.sync.shoppinglists.helpers.ShoppingListReferenceResolver;
import com.commercetools.sync.shoppinglists.helpers.ShoppingListSyncStatistics;
import com.commercetools.sync.shoppinglists.utils.ShoppingListSyncUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.shoppinglists.ShoppingList;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ShoppingListSync
extends BaseSync<ShoppingListDraft, ShoppingListSyncStatistics, ShoppingListSyncOptions> {
    private static final String CTP_SHOPPING_LIST_UPDATE_FAILED = "Failed to update shopping lists with key: '%s'. Reason: %s";
    private static final String CTP_SHOPPING_LIST_FETCH_FAILED = "Failed to fetch existing shopping lists with keys: '%s'.";
    private static final String FAILED_TO_PROCESS = "Failed to process the ShoppingListDraft with key:'%s'. Reason: %s";
    private final ShoppingListService shoppingListService;
    private final ShoppingListReferenceResolver shoppingListReferenceResolver;
    private final ShoppingListBatchValidator shoppingListBatchValidator;

    public ShoppingListSync(@Nonnull ShoppingListSyncOptions shoppingListSyncOptions) {
        this(shoppingListSyncOptions, new ShoppingListServiceImpl(shoppingListSyncOptions), new CustomerServiceImpl(CustomerSyncOptionsBuilder.of(shoppingListSyncOptions.getCtpClient()).build()), new TypeServiceImpl(shoppingListSyncOptions));
    }

    protected ShoppingListSync(@Nonnull ShoppingListSyncOptions syncOptions, @Nonnull ShoppingListService shoppingListService, @Nonnull CustomerService customerService, @Nonnull TypeService typeService) {
        super(new ShoppingListSyncStatistics(), syncOptions);
        this.shoppingListService = shoppingListService;
        this.shoppingListReferenceResolver = new ShoppingListReferenceResolver((ShoppingListSyncOptions)this.getSyncOptions(), customerService, typeService);
        this.shoppingListBatchValidator = new ShoppingListBatchValidator((ShoppingListSyncOptions)this.getSyncOptions(), (ShoppingListSyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<ShoppingListSyncStatistics> process(@Nonnull List<ShoppingListDraft> shoppingListDrafts) {
        List batches = SyncUtils.batchElements(shoppingListDrafts, ((ShoppingListSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<ShoppingListSyncStatistics> processBatch(@Nonnull List<ShoppingListDraft> batch) {
        ImmutablePair<Set<ShoppingListDraft>, ShoppingListBatchValidator.ReferencedKeys> validationResult = this.shoppingListBatchValidator.validateAndCollectReferencedKeys(batch);
        Set shoppingListDrafts = (Set)validationResult.getLeft();
        if (shoppingListDrafts.isEmpty()) {
            ((ShoppingListSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        return ((CompletableFuture)((CompletableFuture)this.shoppingListReferenceResolver.populateKeyToIdCachesForReferencedKeys((ShoppingListBatchValidator.ReferencedKeys)validationResult.getRight()).handle(ImmutablePair::new)).thenCompose(cachingResponse -> {
            Throwable cachingException = (Throwable)cachingResponse.getRight();
            if (cachingException != null) {
                this.handleError(new SyncException("Failed to build a cache of keys to ids.", cachingException), shoppingListDrafts.size());
                return CompletableFuture.completedFuture(null);
            }
            Set<String> shoppingListDraftKeys = shoppingListDrafts.stream().map(ShoppingListDraft::getKey).collect(Collectors.toSet());
            return this.shoppingListService.fetchMatchingShoppingListsByKeys(shoppingListDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
                Set fetchedShoppingLists = (Set)fetchResponse.getLeft();
                Throwable exception = (Throwable)fetchResponse.getRight();
                if (exception != null) {
                    String errorMessage = String.format(CTP_SHOPPING_LIST_FETCH_FAILED, shoppingListDraftKeys);
                    this.handleError(new SyncException(errorMessage, exception), shoppingListDraftKeys.size());
                    return CompletableFuture.completedFuture(null);
                }
                return this.syncBatch(fetchedShoppingLists, shoppingListDrafts);
            });
        })).thenApply(ignoredResult -> {
            ((ShoppingListSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (ShoppingListSyncStatistics)this.statistics;
        });
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<ShoppingList> oldShoppingLists, @Nonnull Set<ShoppingListDraft> newShoppingListDrafts) {
        Map keyShoppingListsMap = oldShoppingLists.stream().collect(Collectors.toMap(ShoppingList::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newShoppingListDrafts.stream().map(shoppingListDraft -> this.shoppingListReferenceResolver.resolveReferences((ShoppingListDraft)shoppingListDraft).thenCompose(resolvedShoppingListDraft -> this.syncDraft(keyShoppingListsMap, (ShoppingListDraft)resolvedShoppingListDraft)).exceptionally(completionException -> {
            String errorMessage = String.format(FAILED_TO_PROCESS, shoppingListDraft.getKey(), completionException.getMessage());
            this.handleError(new SyncException(errorMessage, (Throwable)completionException), 1);
            return null;
        })).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Void> syncDraft(@Nonnull Map<String, ShoppingList> keyShoppingListMap, @Nonnull ShoppingListDraft newShoppingListDraft) {
        ShoppingList shoppingListFromMap = keyShoppingListMap.get(newShoppingListDraft.getKey());
        return Optional.ofNullable(shoppingListFromMap).map(oldShoppingList -> this.buildActionsAndUpdate((ShoppingList)oldShoppingList, newShoppingListDraft)).orElseGet(() -> this.applyCallbackAndCreate(newShoppingListDraft));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> buildActionsAndUpdate(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingListDraft) {
        List updateActions = ShoppingListSyncUtils.buildActions(oldShoppingList, newShoppingListDraft, (ShoppingListSyncOptions)this.syncOptions);
        List<UpdateAction<ShoppingList>> updateActionsAfterCallback = ((ShoppingListSyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, newShoppingListDraft, oldShoppingList);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateShoppinglist(oldShoppingList, newShoppingListDraft, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Void> updateShoppinglist(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingListDraft, @Nonnull List<UpdateAction<ShoppingList>> updateActionsAfterCallback) {
        return this.shoppingListService.updateShoppingList(oldShoppingList, updateActionsAfterCallback).handle(ImmutablePair::of).thenCompose(updateResponse -> {
            Throwable exception = (Throwable)updateResponse.getValue();
            if (exception != null) {
                return ShoppingListSync.executeSupplierIfConcurrentModificationException(exception, () -> this.fetchAndUpdate(oldShoppingList, newShoppingListDraft), () -> {
                    String errorMessage = String.format(CTP_SHOPPING_LIST_UPDATE_FAILED, newShoppingListDraft.getKey(), exception.getMessage());
                    this.handleError(new SyncException(errorMessage, exception), 1);
                    return CompletableFuture.completedFuture(null);
                });
            }
            ((ShoppingListSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private CompletionStage<Void> fetchAndUpdate(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingListDraft) {
        String shoppingListKey = oldShoppingList.getKey();
        return this.shoppingListService.fetchShoppingList(shoppingListKey).handle(ImmutablePair::of).thenCompose(fetchResponse -> {
            Optional fetchedShoppingListOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_SHOPPING_LIST_UPDATE_FAILED, shoppingListKey, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(new SyncException(errorMessage, exception), 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedShoppingListOptional.map(fetchedShoppingList -> this.buildActionsAndUpdate((ShoppingList)fetchedShoppingList, newShoppingListDraft)).orElseGet(() -> {
                String errorMessage = String.format(CTP_SHOPPING_LIST_UPDATE_FAILED, shoppingListKey, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(new SyncException(errorMessage, null), 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    @Nonnull
    private CompletionStage<Void> applyCallbackAndCreate(@Nonnull ShoppingListDraft shoppingListDraft) {
        return ((ShoppingListSyncOptions)this.syncOptions).applyBeforeCreateCallback(shoppingListDraft).map(draft -> this.shoppingListService.createShoppingList((ShoppingListDraft)draft).thenAccept(optional -> {
            if (optional.isPresent()) {
                ((ShoppingListSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((ShoppingListSyncStatistics)this.statistics).incrementFailed();
            }
        })).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private void handleError(@Nonnull SyncException syncException, int failedTimes) {
        ((ShoppingListSyncOptions)this.syncOptions).applyErrorCallback(syncException);
        ((ShoppingListSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

